/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.operator.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSNumber;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.impl.pb.cos.PBCosNumber;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.operator.Operator;

public abstract class PBOperator
extends GenericModelObject
implements Operator {
    public static final int MAX_NUMBER_OF_ELEMENTS = 1;
    protected final List<COSBase> arguments;

    protected PBOperator(List<COSBase> arguments, String opType) {
        super(opType);
        this.arguments = arguments;
    }

    protected List<CosNumber> getLastNumber() {
        COSBase base;
        if (!this.arguments.isEmpty() && (base = this.arguments.get(this.arguments.size() - 1)) instanceof COSNumber) {
            ArrayList<PBCosNumber> cosNumbers = new ArrayList<PBCosNumber>(1);
            cosNumbers.add(PBCosNumber.fromPDFBoxNumber(base));
            return Collections.unmodifiableList(cosNumbers);
        }
        return Collections.emptyList();
    }

    protected List<CosReal> getLastReal() {
        COSBase base;
        if (!this.arguments.isEmpty() && (base = this.arguments.get(this.arguments.size() - 1)) instanceof COSFloat) {
            ArrayList<PBCosReal> cosReals = new ArrayList<PBCosReal>(1);
            cosReals.add(new PBCosReal((COSFloat)base));
            return Collections.unmodifiableList(cosReals);
        }
        return Collections.emptyList();
    }

    protected List<CosNumber> getListOfNumbers() {
        ArrayList<CosNumber> list = new ArrayList<CosNumber>();
        for (COSBase base : this.arguments) {
            if (base instanceof COSArray) {
                PBOperator.addArrayElementsAsNumbers(list, (COSArray)base);
                continue;
            }
            if (!(base instanceof COSNumber)) continue;
            list.add(PBCosNumber.fromPDFBoxNumber(base));
        }
        return Collections.unmodifiableList(list);
    }

    protected List<CosReal> getListOfReals() {
        ArrayList<CosReal> list = new ArrayList<CosReal>();
        for (COSBase base : this.arguments) {
            if (base instanceof COSArray) {
                PBOperator.addArrayElementsAsReals(list, (COSArray)base);
                continue;
            }
            if (!(base instanceof COSFloat)) continue;
            list.add(new PBCosReal((COSFloat)base));
        }
        return Collections.unmodifiableList(list);
    }

    private static void addArrayElementsAsReals(List<CosReal> list, COSArray base) {
        for (COSBase arg : base) {
            if (!(arg instanceof COSFloat)) continue;
            list.add(new PBCosReal((COSFloat)arg));
        }
    }

    private static void addArrayElementsAsNumbers(List<CosNumber> list, COSArray base) {
        for (COSBase arg : base) {
            list.add(PBCosNumber.fromPDFBoxNumber(arg));
        }
    }
}

