/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDExtGState;

public class GFExtGStateFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDExtGState exGState;
    private String id;
    private String fontChildID;

    public GFExtGStateFeaturesObject(PDExtGState exGState, String id, String fontChildID) {
        this.exGState = exGState;
        this.id = id;
        this.fontChildID = fontChildID;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.EXT_G_STATE;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.exGState != null && !this.exGState.empty()) {
            Boolean nonStrokingOverprintControl;
            Boolean strokingOverprintControl;
            Boolean automaticStrokeAdjustment;
            Boolean alphaSourceFlag;
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"graphicsState");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            if ((alphaSourceFlag = this.exGState.getAlphaSourceFlag()) != null) {
                root.addChild("transparency").setValue(String.valueOf(alphaSourceFlag == false));
            }
            if ((automaticStrokeAdjustment = this.exGState.getAutomaticStrokeAdjustment()) != null) {
                root.addChild("strokeAdjustment").setValue(String.valueOf(automaticStrokeAdjustment));
            }
            if ((strokingOverprintControl = this.exGState.getStrokingOverprintControl()) != null) {
                root.addChild("overprintForStroke").setValue(String.valueOf(strokingOverprintControl));
            }
            if ((nonStrokingOverprintControl = this.exGState.getNonStrokingOverprintControl()) != null) {
                root.addChild("overprintForFill").setValue(String.valueOf(nonStrokingOverprintControl));
            }
            if (this.fontChildID != null) {
                FeatureTreeNode resources = root.addChild("resources");
                FeatureTreeNode fonts = resources.addChild("fonts");
                FeatureTreeNode font = fonts.addChild("font");
                font.setAttribute(ID, this.fontChildID);
            }
            collection.addNewFeatureTree(FeatureObjectType.EXT_G_STATE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }
}

