package org.verapdf.gui;

import org.verapdf.gui.tools.GUIConstants;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

/**
 * Panel with veraPDF logo
 *
 * @author Maksim Bezrukov
 */
class LogoPanel extends JPanel {

	/**
	 * ID for serialisation
	 */
	private static final long serialVersionUID = -3623071197419943686L;

	private final transient BufferedImage logo;
	private int borderWidth;
	private Color background;

	LogoPanel(String logoName, Color backgroundColor, int borderWidth) throws IOException {
		this.borderWidth = borderWidth;
		try (InputStream is = getClass().getClassLoader().getResourceAsStream(logoName)) {
			this.logo = ImageIO.read(is);
		}
		this.background = backgroundColor;
		this.setLayout(null);

		setBackground(backgroundColor);

		setPreferredSize(new Dimension(GUIConstants.LOGO_PANEL_PREFERRED_SIZE_WIDTH, GUIConstants.LOGO_PANEL_PREFERRED_SIZE_HEIGHT));
	}

	/**
	 * Paints the component
	 *
	 * @param g graphics for painting
	 */
	@Override
	public void paint(Graphics g) {
		super.paint(g);

		int imageHeight = getHeight() - this.borderWidth * 2;
		int imageWidth = this.logo.getWidth() * imageHeight / this.logo.getHeight();
		int imageStartX = (getWidth() - imageWidth) / 2;

		g.setColor(this.background);

		g.drawImage(this.logo, imageStartX, this.borderWidth, imageStartX + imageWidth, this.borderWidth + imageHeight, 0, 0, this.logo.getWidth(), this.logo.getHeight(), this);

	}

}
