package org.verapdf.gui;

import org.verapdf.gui.tools.GUIConstants;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

/**
 * Mini logo panel. Represents mini logo and link to site.
 *
 * @author Maksim Bezrukov
 */
class MiniLogoPanel extends JPanel {

	/**
	 * ID for serialisation
	 */
	private static final long serialVersionUID = -199053265127458738L;

	MiniLogoPanel(String logoPath) throws IOException {

		setLayout(new FlowLayout(FlowLayout.LEFT));

		JLabel label = new JLabel(GUIConstants.LABEL_TEXT);
		try (InputStream is = getClass().getClassLoader().getResourceAsStream(logoPath)) {
			final BufferedImage image = ImageIO.read(is);
			Icon icon = new Icon() {

				private static final double SCALE = 0.3;

				@Override
				public void paintIcon(Component c, Graphics g, int x, int y) {
					g.drawImage(image, 0, 0, getIconWidth(), getIconHeight(), 0, 0, image.getWidth(), image.getHeight(), null);
				}

				@Override
				public int getIconWidth() {
					return (int) (image.getWidth() * SCALE);
				}

				@Override
				public int getIconHeight() {
					return (int) (image.getHeight() * SCALE);
				}
			};
			label.setIcon(icon);
		}

		add(label);

	}
}
