/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cmap.CIDRange;
import org.apache.fontbox.cmap.CodespaceRange;

public class CMap {
    private int wmode = 0;
    private String cmapName = null;
    private String cmapVersion = null;
    private int cmapType = -1;
    private String registry = null;
    private String ordering = null;
    private int supplement = 0;
    private final List<CodespaceRange> codespaceRanges = new ArrayList<CodespaceRange>();
    private final Map<Integer, String> charToUnicode = new HashMap<Integer, String>();
    private final Map<Integer, Integer> codeToCid = new HashMap<Integer, Integer>();
    private final List<CIDRange> codeToCidRanges = new LinkedList<CIDRange>();
    private static final String SPACE = " ";
    private int spaceMapping = -1;

    CMap() {
    }

    public boolean hasCIDMappings() {
        return !this.codeToCid.isEmpty() || !this.codeToCidRanges.isEmpty();
    }

    public boolean hasUnicodeMappings() {
        return !this.charToUnicode.isEmpty();
    }

    public String toUnicode(int code) {
        return this.charToUnicode.get(code);
    }

    public int readCode(InputStream in) throws IOException {
        int i;
        in.mark(4);
        ArrayList<Byte> bytes = new ArrayList<Byte>(4);
        for (i = 0; i < 4; ++i) {
            bytes.add((byte)in.read());
            for (CodespaceRange range : this.codespaceRanges) {
                if (!range.isFullMatch(bytes)) continue;
                return this.toInt(bytes);
            }
        }
        in.reset();
        bytes = new ArrayList(4);
        for (i = 0; i < 4; ++i) {
            bytes.add((byte)in.read());
            CodespaceRange match = null;
            CodespaceRange shortest = null;
            for (CodespaceRange range : this.codespaceRanges) {
                if (range.isPartialMatch((Byte)bytes.get(i), i)) {
                    if (match == null) {
                        match = range;
                    } else if (range.getStart().length < match.getStart().length) {
                        match = range;
                    }
                }
                if (shortest != null && range.getStart().length >= shortest.getStart().length) continue;
                shortest = range;
            }
            if (match == null) {
                match = shortest;
            }
            if (match == null || match.getStart().length != bytes.size()) continue;
            return this.toInt(bytes);
        }
        throw new IOException("CMap is invalid");
    }

    private int toInt(List<Byte> data) {
        int code = 0;
        for (byte b : data) {
            code <<= 8;
            code |= (b + 256) % 256;
        }
        return code;
    }

    public int toCID(int code) {
        if (this.codeToCid.containsKey(code)) {
            return this.codeToCid.get(code);
        }
        for (CIDRange range : this.codeToCidRanges) {
            int ch = range.map((char)code);
            if (ch == -1) continue;
            return ch;
        }
        return 0;
    }

    private int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        for (int i = 0; i < length; ++i) {
            code <<= 8;
            code |= (data[offset + i] + 256) % 256;
        }
        return code;
    }

    void addCharMapping(byte[] codes, String unicode) {
        int code = this.getCodeFromArray(codes, 0, codes.length);
        this.charToUnicode.put(code, unicode);
        if (SPACE.equals(unicode)) {
            this.spaceMapping = code;
        }
    }

    void addCIDMapping(int code, int cid) {
        this.codeToCid.put(cid, code);
    }

    void addCIDRange(char from, char to, int cid) {
        this.codeToCidRanges.add(0, new CIDRange(from, to, cid));
    }

    void addCodespaceRange(CodespaceRange range) {
        this.codespaceRanges.add(range);
    }

    void useCmap(CMap cmap) {
        this.codespaceRanges.addAll(cmap.codespaceRanges);
        this.charToUnicode.putAll(cmap.charToUnicode);
        this.codeToCid.putAll(cmap.codeToCid);
        this.codeToCidRanges.addAll(cmap.codeToCidRanges);
    }

    public int getWMode() {
        return this.wmode;
    }

    public void setWMode(int newWMode) {
        this.wmode = newWMode;
    }

    public String getName() {
        return this.cmapName;
    }

    public void setName(String name) {
        this.cmapName = name;
    }

    public String getVersion() {
        return this.cmapVersion;
    }

    public void setVersion(String version) {
        this.cmapVersion = version;
    }

    public int getType() {
        return this.cmapType;
    }

    public void setType(int type) {
        this.cmapType = type;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String newRegistry) {
        this.registry = newRegistry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String newOrdering) {
        this.ordering = newOrdering;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int newSupplement) {
        this.supplement = newSupplement;
    }

    public int getSpaceMapping() {
        return this.spaceMapping;
    }

    public String toString() {
        return this.cmapName;
    }
}

