/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFileOutputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadInputStream;
import org.apache.pdfbox.io.RandomAccessReadWrapper;
import org.apache.pdfbox.io.ScratchFile;

public class COSStream
extends COSDictionary
implements Closeable {
    private static final int BUFFER_SIZE = 16384;
    private RandomAccess tempBuffer;
    private RandomAccess filteredBuffer;
    private RandomAccess unfilteredBuffer;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;
    private DecodeResult decodeResult;
    private final ScratchFile scratchFile;
    private Long originLength = 0L;
    private Boolean streamKeywordCRLFCompliant = true;
    private Boolean endstreamKeywordEOLCompliant = true;

    public COSStream() {
        this((ScratchFile)null);
    }

    public COSStream(COSDictionary dictionary) {
        this(dictionary, null);
    }

    public COSStream(ScratchFile scratchFile) {
        this.scratchFile = scratchFile;
    }

    public COSStream(COSDictionary dictionary, ScratchFile scratchFile) {
        super(dictionary);
        this.scratchFile = scratchFile;
    }

    private RandomAccess createBuffer() throws IOException {
        if (this.scratchFile != null) {
            return this.scratchFile.createBuffer();
        }
        return new RandomAccessBuffer();
    }

    public InputStream getFilteredStream() throws IOException {
        InputStream retval;
        this.checkFilteredBuffer();
        if (this.filteredStream != null) {
            long position = this.filteredStream.getPosition();
            long length = this.filteredStream.getLengthWritten();
            retval = new BufferedInputStream(new RandomAccessReadInputStream(this.getFilteredBuffer(), position, length), 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public RandomAccessRead getFilteredRandomAccess() throws IOException {
        RandomAccessRead retval;
        this.checkFilteredBuffer();
        if (this.filteredStream != null) {
            long position = this.filteredStream.getPosition();
            long length = this.filteredStream.getLengthWritten();
            retval = new RandomAccessReadWrapper(this.getFilteredBuffer(), position, length);
        } else {
            retval = new RandomAccessBuffer();
        }
        return retval;
    }

    private void checkFilteredBuffer() throws IOException {
        if (this.getFilteredBuffer() != null && this.getFilteredBuffer().isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
        if (this.filteredStream == null) {
            this.doEncode();
        }
    }

    public long getFilteredLength() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        return this.filteredStream.getLength();
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval;
        this.checkUnfilteredBuffer();
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLengthWritten();
            retval = new BufferedInputStream(new RandomAccessReadInputStream(this.getUnfilteredBuffer(), position, length), 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public RandomAccessRead getUnfilteredRandomAccess() throws IOException {
        RandomAccessRead retval;
        this.checkUnfilteredBuffer();
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLengthWritten();
            retval = new RandomAccessReadWrapper(this.getUnfilteredBuffer(), position, length);
        } else {
            retval = new RandomAccessBuffer();
        }
        return retval;
    }

    private void checkUnfilteredBuffer() throws IOException {
        if (this.getUnfilteredBuffer() != null && this.getUnfilteredBuffer().isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
    }

    public DecodeResult getDecodeResult() throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream == null || this.decodeResult == null) {
            StringBuilder filterInfo = new StringBuilder();
            COSBase filters = this.getFilters();
            if (filters != null) {
                filterInfo.append(" - filter: ");
                if (filters instanceof COSName) {
                    filterInfo.append(((COSName)filters).getName());
                } else if (filters instanceof COSArray) {
                    COSArray filterArray = (COSArray)filters;
                    for (int i = 0; i < filterArray.size(); ++i) {
                        if (filterArray.size() > 1) {
                            filterInfo.append(", ");
                        }
                        filterInfo.append(((COSName)filterArray.get(i)).getName());
                    }
                }
            }
            String subtype = this.getNameAsString(COSName.SUBTYPE);
            throw new IOException(subtype + " stream was not read" + filterInfo);
        }
        return this.decodeResult;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        COSBase filters = this.getFilters();
        if (filters == null) {
            this.unFilteredStream = new RandomAccessFileOutputStream(this.getUnfilteredBuffer(true));
            IOUtils.copy(this.getFilteredStream(), this.unFilteredStream);
            this.decodeResult = DecodeResult.DEFAULT;
        } else if (filters instanceof COSName) {
            this.copyBuffer(this.getFilteredBuffer(false), this.filteredStream.getPosition());
            this.doDecode((COSName)filters, 0, this.getFilteredBuffer().length(), this.getUnfilteredBuffer(true));
        } else if (filters instanceof COSArray) {
            this.copyBuffer(this.getFilteredBuffer(false), this.filteredStream.getPosition());
            COSArray filterArray = (COSArray)filters;
            int filterArraysize = filterArray.size();
            for (int i = 0; i < filterArraysize; ++i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doDecode(filterName, i, this.getFilteredBuffer().length(), this.getUnfilteredBuffer(true));
                if (i >= filterArraysize - 1) continue;
                this.copyBuffer(this.getUnfilteredBuffer(false), 0L);
            }
            this.tempBuffer.close();
        } else {
            throw new IOException("Error: Unknown filter type:" + filters);
        }
    }

    private void copyBuffer(RandomAccess srcBuffer, long position) throws IOException {
        int length = (int)(srcBuffer.length() - position);
        byte[] byteBuffer = new byte[length];
        srcBuffer.seek(position);
        srcBuffer.read(byteBuffer, 0, length);
        if (this.tempBuffer == null) {
            this.tempBuffer = new RandomAccessBuffer();
        } else {
            this.tempBuffer.clear();
        }
        this.tempBuffer.write(byteBuffer, 0, length);
        this.tempBuffer.seek(0L);
    }

    private RandomAccess doDecode(COSName filterName, int filterIndex, long length, RandomAccess destBuffer) throws IOException {
        RandomAccess result = destBuffer;
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        if (length == 0L) {
            if (result == null) {
                result = this.createBuffer();
            }
        } else {
            result = this.attemptDecode(filter, filterIndex, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccess attemptDecode(Filter filter, int filterIndex, RandomAccess destBuffer) throws IOException {
        BufferedInputStream input = null;
        RandomAccess result = null;
        try {
            input = new BufferedInputStream(new RandomAccessReadInputStream(this.tempBuffer, 0L, this.tempBuffer.length()), 16384);
            IOUtils.closeQuietly(this.unFilteredStream);
            result = destBuffer == null ? this.createBuffer() : destBuffer;
            this.unFilteredStream = new RandomAccessFileOutputStream(result);
            this.decodeResult = filter.decode(input, this.unFilteredStream, this, filterIndex);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        return result;
    }

    private void doEncode() throws IOException {
        COSBase filters = this.getFilters();
        if (filters == null) {
            this.filteredStream = new RandomAccessFileOutputStream(this.getFilteredBuffer(true));
            IOUtils.copy(this.getUnfilteredStream(), this.filteredStream);
        } else if (filters instanceof COSName) {
            this.copyBuffer(this.getUnfilteredBuffer(false), this.unFilteredStream.getPosition());
            this.doEncode((COSName)filters, 0, this.getFilteredBuffer(true));
        } else if (filters instanceof COSArray) {
            this.copyBuffer(this.getUnfilteredBuffer(false), this.unFilteredStream.getPosition());
            COSArray filterArray = (COSArray)filters;
            for (int i = filterArray.size() - 1; i >= 0; --i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doEncode(filterName, i, this.getFilteredBuffer(true));
                if (i <= 0) continue;
                this.copyBuffer(this.getFilteredBuffer(false), 0L);
            }
            this.tempBuffer.close();
        }
    }

    private RandomAccess doEncode(COSName filterName, int filterIndex, RandomAccess destBuffer) throws IOException {
        RandomAccess result = null;
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessReadInputStream(this.tempBuffer, 0L, this.tempBuffer.length()), 16384);
        IOUtils.closeQuietly(this.filteredStream);
        result = destBuffer == null ? this.createBuffer() : destBuffer;
        this.filteredStream = new RandomAccessFileOutputStream(result);
        filter.encode(input, this.filteredStream, this, filterIndex);
        IOUtils.closeQuietly(input);
        return result;
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream input = null;
        try {
            input = this.getUnfilteredStream();
            IOUtils.copy(input, out);
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        COSString string = new COSString(out.toByteArray());
        return string.getString();
    }

    public OutputStream createFilteredStream() throws IOException {
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = null;
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.getFilteredBuffer(true));
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        OutputStream out = this.createFilteredStream();
        this.filteredStream.setExpectedLength(expectedLength);
        return out;
    }

    public void setFilters(COSBase filters) throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        this.setItem(COSName.FILTER, filters);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = new RandomAccessFileOutputStream(this.getUnfilteredBuffer(true));
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }

    private RandomAccess getFilteredBuffer() {
        return this.filteredBuffer;
    }

    private RandomAccess getFilteredBuffer(boolean clear) throws IOException {
        if (this.filteredBuffer == null) {
            this.filteredBuffer = this.createBuffer();
        } else if (clear) {
            this.filteredBuffer.clear();
        }
        return this.filteredBuffer;
    }

    private RandomAccess getUnfilteredBuffer() {
        return this.unfilteredBuffer;
    }

    private RandomAccess getUnfilteredBuffer(boolean clear) throws IOException {
        if (this.unfilteredBuffer == null) {
            this.unfilteredBuffer = this.createBuffer();
        } else if (clear) {
            this.unfilteredBuffer.clear();
        }
        return this.unfilteredBuffer;
    }

    public Long getOriginLength() {
        return this.originLength;
    }

    public void setOriginLength(Long originLength) {
        this.originLength = originLength;
    }

    public boolean isStreamKeywordCRLFCompliant() {
        return this.streamKeywordCRLFCompliant;
    }

    public void setStreamKeywordCRLFCompliant(boolean streamSpacingsComplyPDFA) {
        this.streamKeywordCRLFCompliant = streamSpacingsComplyPDFA;
    }

    public Boolean isEndstreamKeywordEOLCompliant() {
        return this.endstreamKeywordEOLCompliant;
    }

    public void setEndstreamKeywordEOLCompliant(Boolean endStreamSpacingsComplyPDFA) {
        this.endstreamKeywordEOLCompliant = endStreamSpacingsComplyPDFA;
    }

    @Override
    public void close() throws IOException {
        if (this.filteredStream != null) {
            this.filteredStream.close();
        }
        if (this.unFilteredStream != null) {
            this.unFilteredStream.close();
        }
        if (this.unfilteredBuffer != null) {
            this.unfilteredBuffer.close();
        }
        if (this.filteredBuffer != null) {
            this.filteredBuffer.close();
        }
    }

    @Override
    public boolean equals(Object obj) {
        COSBase cosBase;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof COSObject) {
            return this.equals(((COSObject)obj).getObject());
        }
        COSStream that = (COSStream)obj;
        for (Map.Entry<COSName, COSBase> entry : this.entrySet()) {
            if (entry.getKey().equals(COSName.FILTER) || entry.getKey().equals(COSName.DECODE_PARMS) || entry.getKey().equals(COSName.LENGTH)) continue;
            cosBase = (COSBase)that.items.get(entry.getKey());
            if (entry.getValue().equals(cosBase)) continue;
            return false;
        }
        for (Map.Entry<COSName, COSBase> entry : that.entrySet()) {
            if (entry.getKey().equals(COSName.FILTER) || entry.getKey().equals(COSName.DECODE_PARMS) || entry.getKey().equals(COSName.LENGTH)) continue;
            cosBase = (COSBase)this.items.get(entry.getKey());
            if (entry.getValue().equals(cosBase)) continue;
            return false;
        }
        try {
            RandomAccessRead thisRead = this.getUnfilteredRandomAccess();
            RandomAccessRead thatRead = that.getUnfilteredRandomAccess();
            if (thisRead.length() != thatRead.length()) {
                return false;
            }
            int i = 0;
            while ((long)i < thisRead.length()) {
                if (thisRead.read() != thatRead.read()) {
                    return false;
                }
                ++i;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

