/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.BaseParser;

public class SignatureParser
extends BaseParser {
    private static final Log LOGGER = LogFactory.getLog(SignatureParser.class);
    private static final byte[] EOF_STRING = "%%EOF".getBytes();
    private long[] byteRange = new long[4];

    public SignatureParser(RandomAccessRead stream, COSDocument document) throws IOException {
        super(stream);
        this.document = document;
    }

    private void parseDictionary() throws IOException {
        this.readExpectedChar('<');
        this.readExpectedChar('<');
        this.skipSpaces();
        boolean done = false;
        while (!done) {
            this.skipSpaces();
            char c = (char)this.pdfSource.peek();
            if (c == '>') {
                done = true;
                continue;
            }
            if (c == '/') {
                if (!this.parseSignatureNameValuePair()) continue;
                done = true;
                continue;
            }
            LOGGER.warn("Invalid dictionary, found: '" + c + "' but expected: '/'");
            return;
        }
    }

    private void passCOSDictionaryValue() throws IOException {
        long numOffset = this.pdfSource.getPosition();
        COSBase number = this.parseDirObject();
        this.skipSpaces();
        if (!this.isDigit()) {
            return;
        }
        long genOffset = this.pdfSource.getPosition();
        COSBase generationNumber = this.parseDirObject();
        this.skipSpaces();
        this.readExpectedChar('R');
        if (!(number instanceof COSInteger)) {
            throw new IOException("expected number, actual=" + number + " at offset " + numOffset);
        }
        if (!(generationNumber instanceof COSInteger)) {
            throw new IOException("expected number, actual=" + number + " at offset " + genOffset);
        }
    }

    public long[] getByteRangeBySignatureOffset(long signatureOffset) throws IOException {
        this.pdfSource.seek(signatureOffset);
        this.skipID();
        this.byteRange[0] = 0L;
        this.parseDictionary();
        this.byteRange[3] = this.getOffsetOfNextEOF(this.byteRange[2]) - this.byteRange[2] + 1L;
        return this.byteRange;
    }

    private boolean parseSignatureNameValuePair() throws IOException {
        COSName key = this.parseCOSName();
        if (key.compareTo(COSName.CONTENTS) != 0) {
            this.passCOSDictionaryValue();
            return false;
        }
        this.parseSignatureValue();
        return true;
    }

    private void parseSignatureValue() throws IOException {
        this.skipSpaces();
        long numOffset1 = this.pdfSource.getPosition();
        COSBase number = this.parseDirObject();
        long numOffset2 = this.pdfSource.getPosition();
        this.skipSpaces();
        if (!this.isDigit()) {
            this.byteRange[1] = numOffset1;
            this.byteRange[2] = numOffset2;
            return;
        }
        long genOffset = this.pdfSource.getPosition();
        COSBase generationNumber = this.parseDirObject();
        this.skipSpaces();
        int c = this.pdfSource.read();
        if (c == 82) {
            if (!(number instanceof COSInteger)) {
                throw new IOException("expected number, actual=" + number + " at offset " + numOffset1);
            }
            if (!(generationNumber instanceof COSInteger)) {
                throw new IOException("expected number, actual=" + number + " at offset " + genOffset);
            }
            COSObjectKey key = new COSObjectKey(((COSInteger)number).longValue(), ((COSInteger)generationNumber).intValue());
            long keyOffset = this.document.getXrefTable().get(key);
            this.pdfSource.seek(keyOffset + this.document.getHeaderOffset());
            this.parseSignatureValue();
        }
        if (c != 111) {
            throw new IOException("\"R\" or \"obj\" expected, but '" + (char)c + "' found.");
        }
        this.readExpectedChar('b');
        this.readExpectedChar('j');
        this.skipSpaces();
        numOffset1 = this.pdfSource.getPosition();
        this.parseCOSString();
        numOffset2 = this.pdfSource.getPosition();
        this.byteRange[1] = numOffset1;
        this.byteRange[2] = numOffset2;
    }

    private long getOffsetOfNextEOF(long currentOffset) throws IOException {
        byte[] buffer = new byte[EOF_STRING.length];
        this.pdfSource.seek(currentOffset + this.document.getHeaderOffset());
        this.pdfSource.read(buffer);
        this.pdfSource.rewind(buffer.length - 1);
        while (!Arrays.equals(buffer, EOF_STRING)) {
            this.pdfSource.read(buffer);
            if (this.pdfSource.isEOF()) {
                this.pdfSource.seek(currentOffset + this.document.getHeaderOffset());
                return this.pdfSource.length();
            }
            this.pdfSource.rewind(buffer.length - 1);
        }
        long result = this.pdfSource.getPosition() + (long)buffer.length - 1L;
        this.pdfSource.seek(currentOffset + this.document.getHeaderOffset());
        return result;
    }

    private void skipID() throws IOException {
        this.parseDirObject();
        this.skipSpaces();
        this.parseDirObject();
        this.skipSpaces();
        this.readExpectedChar('o');
        this.readExpectedChar('b');
        this.readExpectedChar('j');
        this.skipSpaces();
    }
}

