/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="releaseDetails")
public final class ReleaseDetails {
    public static final String APPLICATION_PROPERTIES_ROOT = "org/verapdf/release/";
    public static final String PROPERTIES_EXT = "properties";
    public static final String LIBRARY_DETAILS_RESOURCE = "org/verapdf/release/library.properties";
    private static final String RAW_DATE_FORMAT = "${maven.build.timestamp.format}";
    private static final String RIGHTS = "Developed and released by the veraPDF Consortium.\nFunded by the PREFORMA project.\nReleased under the GNU General Public License v3\nand the Mozilla Public License v2.\n";
    private static final ReleaseDetails DEFAULT = new ReleaseDetails();
    private static final Map<String, ReleaseDetails> DETAILS = new HashMap<String, ReleaseDetails>();
    @XmlAttribute
    private final String id;
    @XmlAttribute
    private final String version;
    @XmlAttribute
    private final Date buildDate;
    @XmlElement
    private final String rights = "Developed and released by the veraPDF Consortium.\nFunded by the PREFORMA project.\nReleased under the GNU General Public License v3\nand the Mozilla Public License v2.\n";

    private ReleaseDetails() {
        this("name", "version", new Date());
    }

    private ReleaseDetails(String id, String version, Date buildDate) {
        this.id = id;
        this.version = version;
        this.buildDate = new Date(buildDate.getTime());
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getBuildDate() {
        return new Date(this.buildDate.getTime());
    }

    public String getRights() {
        return this.rights;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.buildDate == null ? 0 : this.buildDate.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseDetails other = (ReleaseDetails)obj;
        if (this.buildDate == null ? other.buildDate != null : !this.buildDate.equals(other.buildDate)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "ReleaseDetails [id=" + this.id + ", version=" + this.version + ", buildDate=" + this.buildDate + "]";
    }

    public static ReleaseDetails defaultInstance() {
        return DEFAULT;
    }

    public static ReleaseDetails getInstance() {
        if (DETAILS.isEmpty()) {
            return ReleaseDetails.defaultInstance();
        }
        return DETAILS.values().toArray(new ReleaseDetails[DETAILS.size()])[0];
    }

    public static Set<String> getIds() {
        return DETAILS.keySet();
    }

    public static ReleaseDetails byId(String id) {
        if (DETAILS.containsKey(id)) {
            return DETAILS.get(id);
        }
        return ReleaseDetails.defaultInstance();
    }

    public static void addDetailsFromResource(String resourceName) {
        ReleaseDetails details = ReleaseDetails.fromResource(resourceName);
        DETAILS.put(details.id, details);
    }

    static void toXml(ReleaseDetails toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ReleaseDetails.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    static ReleaseDetails fromXml(InputStream toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = ReleaseDetails.getUnmarshaller();
        return (ReleaseDetails)stringUnmarshaller.unmarshal(toConvert);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ReleaseDetails fromResource(String resourceName) {
        try (InputStream is = ReleaseDetails.class.getClassLoader().getResourceAsStream(resourceName);){
            if (is == null) {
                ReleaseDetails releaseDetails = DEFAULT;
                return releaseDetails;
            }
            ReleaseDetails releaseDetails = ReleaseDetails.fromPropertiesStream(is);
            return releaseDetails;
        }
        catch (IOException excep) {
            throw new IllegalStateException("Couldn't load ReleaseDetails resource:" + resourceName, excep);
        }
    }

    private static ReleaseDetails fromPropertiesStream(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return ReleaseDetails.fromProperties(props);
    }

    private static ReleaseDetails fromProperties(Properties props) {
        String release = props.getProperty("verapdf.release.version");
        String dateFormat = props.getProperty("verapdf.date.format");
        String id = props.getProperty("verapdf.project.id");
        Date date = new Date();
        if (!dateFormat.equals(RAW_DATE_FORMAT)) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            try {
                date = formatter.parse(props.getProperty("verapdf.release.date"));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new ReleaseDetails(id, release, date);
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ReleaseDetails.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ReleaseDetails.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }

    static {
        ReleaseDetails details = ReleaseDetails.fromResource(LIBRARY_DETAILS_RESOURCE);
        DETAILS.put(details.id, details);
    }
}

