/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.processor.ProcessorImpl;
import org.verapdf.processor.config.Config;
import org.verapdf.processor.config.ConfigIO;
import org.verapdf.processor.config.ProcessingType;
import org.verapdf.report.ItemDetails;

final class VeraPdfCliProcessor {
    private static final Logger LOGGER = Logger.getLogger(VeraPdfCliProcessor.class);
    final boolean recurse;
    private Config config;

    private VeraPdfCliProcessor() throws IOException {
        this(new VeraCliArgParser());
    }

    private VeraPdfCliProcessor(VeraCliArgParser args) throws IOException {
        this.recurse = args.isRecurse();
        if (args.isLoadingConfig()) {
            try {
                this.config = ConfigIO.readConfig();
            }
            catch (IOException e) {
                LOGGER.error("Can not read config file. Using default config", e);
                this.config = new Config();
            }
            catch (JAXBException e) {
                LOGGER.error("Cannot parse config XML. Using default config", e);
                this.config = new Config();
            }
        } else {
            this.config = new Config();
            this.config.setShowPassedRules(args.logPassed());
            this.config.setMaxNumberOfFailedChecks(args.maxFailures());
            this.config.setMaxNumberOfDisplayedFailedChecks(args.maxFailuresDisplayed());
            this.config.setMetadataFixerPrefix(args.prefix());
            this.config.setFixMetadataPathFolder(FileSystems.getDefault().getPath(args.saveFolder(), new String[0]));
            this.config.setProfileWikiPath(args.getProfilesWikiPath());
            this.config.setFixMetadata(args.fixMetadata());
            this.config.setProcessingType(VeraPdfCliProcessor.processingTypeFromArgs(args));
            this.config.setReportType(args.getFormat());
            this.config.setValidationProfilePath(args.getProfileFile() == null ? FileSystems.getDefault().getPath("", new String[0]) : args.getProfileFile().toPath());
            this.config.setFlavour(args.getFlavour());
            this.config.setVerboseCli(args.isVerbose());
            this.config.setPluginsEnabled(args.isPluginsEnabled());
        }
    }

    public Config getConfig() {
        return this.config;
    }

    static ProcessingType processingTypeFromArgs(VeraCliArgParser args) {
        boolean isValidating = args.getFlavour() != PDFAFlavour.NO_FLAVOUR;
        return ProcessingType.getType(isValidating, args.extractFeatures());
    }

    void processPaths(List<String> pdfPaths) {
        if (pdfPaths.isEmpty()) {
            ItemDetails item = ItemDetails.fromValues("STDIN");
            this.processStream(item, System.in);
        }
        for (String pdfPath : pdfPaths) {
            File file = new File(pdfPath);
            if (file.isDirectory()) {
                this.processDir(file);
                continue;
            }
            this.processFile(file);
        }
    }

    static VeraPdfCliProcessor createProcessorFromArgs(VeraCliArgParser args) throws FileNotFoundException, IOException {
        return new VeraPdfCliProcessor(args);
    }

    private void processDir(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                int extIndex = file.getName().lastIndexOf(".");
                String ext = file.getName().substring(extIndex + 1);
                if (!"pdf".equalsIgnoreCase(ext)) continue;
                this.processFile(file);
                continue;
            }
            if (!file.isDirectory() || !this.recurse) continue;
            this.processDir(file);
        }
    }

    private void processFile(File pdfFile) {
        if (VeraPdfCliProcessor.checkFileCanBeProcessed(pdfFile)) {
            try (FileInputStream toProcess = new FileInputStream(pdfFile);){
                this.processStream(ItemDetails.fromFile(pdfFile), toProcess);
            }
            catch (IOException e) {
                System.err.println("Exception raised while processing " + pdfFile.getAbsolutePath());
                e.printStackTrace();
            }
        }
    }

    private static boolean checkFileCanBeProcessed(File file) {
        if (!file.isFile()) {
            System.err.println("Path " + file.getAbsolutePath() + " is not an existing file.");
            return false;
        }
        if (!file.canRead()) {
            System.err.println("Path " + file.getAbsolutePath() + " is not a readable file.");
            return false;
        }
        return true;
    }

    private void processStream(ItemDetails item, InputStream toProcess) {
        ProcessorImpl processor = new ProcessorImpl();
        processor.validate(toProcess, item, this.config, System.out);
    }
}

