/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli.commands;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.processor.config.FormatOption;

public class VeraCliArgParser {
    static final VeraCliArgParser DEFAULT_ARGS = new VeraCliArgParser();
    static final String FLAG_SEP = "-";
    static final String OPTION_SEP = "--";
    static final String HELP_FLAG = "-h";
    static final String HELP = "--help";
    static final String VERSION = "--version";
    static final String FLAVOUR_FLAG = "-f";
    static final String FLAVOUR = "--flavour";
    static final String SUCCESS = "--success";
    static final String PASSED = "--passed";
    static final String LIST_FLAG = "-l";
    static final String LIST = "--list";
    static final String LOAD_PROFILE_FLAG = "-p";
    static final String LOAD_PROFILE = "--profile";
    static final String EXTRACT_FLAG = "-x";
    static final String EXTRACT = "--extract";
    static final String FORMAT = "--format";
    static final String RECURSE_FLAG = "-r";
    static final String RECURSE = "--recurse";
    static final String VERBOSE_FLAG = "-v";
    static final String VERBOSE = "--verbose";
    static final String MAX_FAILURES_DISPLAYED = "--maxfailuresdisplayed";
    static final String MAX_FAILURES = "--maxfailures";
    static final String FIX_METADATA = "--fixmetadata";
    static final String FIX_METADATA_PREFIX = "--prefix";
    static final String FIX_METADATA_FOLDER = "--savefolder";
    static final String PROFILES_WIKI_FLAG = "-pw";
    static final String LOAD_CONFIG_FLAG = "-c";
    static final String LOAD_CONFIG = "--config";
    static final String PROFILES_WIKI = "--profilesWiki";
    static final String USE_PLUGINS = "--plugins";
    @Parameter(names={"-h", "--help"}, description="Shows this message and exits.", help=true)
    private boolean help = false;
    @Parameter(names={"--version"}, description="Version information.")
    private boolean showVersion = false;
    @Parameter(names={"-f", "--flavour"}, description="Choose built in Validation Profile flavour, e.g. 1b. Alternatively supply 0 to turn off PDF/A validation or supply auto to automatic flavour detection from file's metadata.", converter=FlavourConverter.class)
    private PDFAFlavour flavour = PDFAFlavour.PDFA_1_B;
    @Parameter(names={"--success", "--passed"}, description="Logs successful validation checks.")
    private boolean passed = false;
    @Parameter(names={"-l", "--list"}, description="List built in Validation Profiles.")
    private boolean listProfiles = false;
    @Parameter(names={"-p", "--profile"}, description="Load a Validation Profile from given path and exit if loading fails. This overrides any choice or default implied by the -f / --flavour option.", validateWith=ProfileFileValidator.class)
    private File profileFile;
    @Parameter(names={"-x", "--extract"}, description="Extract and report PDF features.")
    private boolean features = false;
    @Parameter(names={"--format"}, description="Choose output format:", converter=FormatConverter.class)
    private FormatOption format = FormatOption.MRR;
    @Parameter(names={"-r", "--recurse"}, description="Recurse directories, only files with a .pdf extension are processed.")
    private boolean isRecurse = false;
    @Parameter(names={"-v", "--verbose"}, description="Adds failed test information to text output.")
    private boolean isVerbose = false;
    @Parameter(names={"--maxfailuresdisplayed"}, description="Sets maximum amount of failed checks displayed for each rule.")
    private int maxFailuresDisplayed = 100;
    @Parameter(names={"--maxfailures"}, description="Sets maximum amount of failed checks.")
    private int maxFailures = -1;
    @Parameter(names={"--fixmetadata"}, description="Performs metadata fix.")
    private boolean fixMetadata = false;
    @Parameter(names={"--prefix"}, description="Prefix for the saved file.")
    private String prefix = "veraPDF_";
    @Parameter(names={"--savefolder"}, description="The folder to save the fixed file to.")
    private String saveFolder = "";
    @Parameter(names={"-pw", "--profilesWiki"}, description="The path to the folder containing Validation Profiles wiki.")
    private String profilesWikiPath = "https://github.com/veraPDF/veraPDF-validation-profiles/wiki";
    @Parameter(names={"-c", "--config"}, description="Loads config form default file, all config flags are ignored.")
    private boolean isLoadingConfig = false;
    @Parameter(names={"--plugins"}, description="Uses plugins in feature extracting.")
    private boolean pluginsEnabled = false;
    @Parameter(description="FILES")
    private List<String> pdfPaths = new ArrayList<String>();

    public boolean showVersion() {
        return this.showVersion;
    }

    public boolean listProfiles() {
        return this.listProfiles;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public int maxFailuresDisplayed() {
        return this.maxFailuresDisplayed;
    }

    public int maxFailures() {
        return this.maxFailures;
    }

    public boolean fixMetadata() {
        return this.fixMetadata;
    }

    public String prefix() {
        return this.prefix;
    }

    public String saveFolder() {
        return this.saveFolder;
    }

    public boolean isRecurse() {
        return this.isRecurse;
    }

    public boolean isHelp() {
        return this.help;
    }

    public FormatOption getFormat() {
        return this.format;
    }

    public boolean logPassed() {
        return this.passed;
    }

    public boolean extractFeatures() {
        return this.features;
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public File getProfileFile() {
        return this.profileFile;
    }

    public List<String> getPdfPaths() {
        return this.pdfPaths;
    }

    public String getProfilesWikiPath() {
        return this.profilesWikiPath;
    }

    public boolean isLoadingConfig() {
        return this.isLoadingConfig;
    }

    public boolean isPluginsEnabled() {
        return this.pluginsEnabled;
    }

    public static final class ProfileFileValidator
    implements IParameterValidator {
        @Override
        public void validate(String name, String value) throws ParameterException {
            File profileFileLocal = new File(value);
            if (!profileFileLocal.isFile() || !profileFileLocal.canRead()) {
                throw new ParameterException("Parameter " + name + " must be the path to an existing, readable file, value=" + value);
            }
        }
    }

    public static final class FlavourConverter
    implements IStringConverter<PDFAFlavour> {
        @Override
        public PDFAFlavour convert(String value) {
            for (PDFAFlavour flavourLocal : PDFAFlavour.values()) {
                if (!flavourLocal.getId().equalsIgnoreCase(value)) continue;
                return flavourLocal;
            }
            throw new ParameterException("Illegal --flavour argument:" + value);
        }
    }

    public static final class FormatConverter
    implements IStringConverter<FormatOption> {
        @Override
        public FormatOption convert(String value) {
            return FormatOption.fromOption(value);
        }
    }
}

