/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.features.FeaturesData;

public final class ImageFeaturesData
extends FeaturesData {
    private final byte[] metadata;
    private final Integer width;
    private final Integer height;
    private final List<Filter> filters;

    private ImageFeaturesData(byte[] metadata, byte[] stream, Integer width, Integer height, List<Filter> filters) {
        super(stream);
        this.metadata = metadata == null ? null : Arrays.copyOf(metadata, metadata.length);
        this.width = width;
        this.height = height;
        if (filters == null) {
            this.filters = null;
        } else {
            this.filters = new ArrayList<Filter>();
            for (Filter fs : filters) {
                this.filters.add(new Filter(fs.name, fs.properties, fs.stream));
            }
        }
    }

    public static ImageFeaturesData newInstance(byte[] metadata, byte[] stream, Integer width, Integer height, List<Filter> filters) {
        if (stream == null) {
            throw new IllegalArgumentException("Image stream can not be null");
        }
        return new ImageFeaturesData(metadata, stream, width, height, filters);
    }

    public byte[] getMetadata() {
        return this.metadata == null ? null : Arrays.copyOf(this.metadata, this.metadata.length);
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public List<Filter> getFilters() {
        return this.filters == null ? null : Collections.unmodifiableList(this.filters);
    }

    public static class Filter {
        private final String name;
        private final Map<String, String> properties;
        private final byte[] stream;

        Filter(String name, Map<String, String> properties, byte[] stream) {
            this.name = name;
            this.properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
            this.stream = stream == null ? null : Arrays.copyOf(stream, stream.length);
        }

        public static Filter newInstance(String name, Map<String, String> properties, byte[] stream) {
            if (name == null) {
                throw new IllegalArgumentException("Name of a filter can not be null");
            }
            if (properties == null) {
                throw new IllegalArgumentException("Properties can not be null");
            }
            return new Filter(name, properties, stream);
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public byte[] getStream() {
            return this.stream == null ? null : Arrays.copyOf(this.stream, this.stream.length);
        }
    }
}

