/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBAnnotationFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private static final int LOCKED_CONTENTS_FLAG = 512;
    private PDAnnotation annot;
    private String id;
    private Set<String> pages;
    private String annotId;
    private String popupId;
    private Set<String> formXObjects;

    public PBAnnotationFeaturesObject(PDAnnotation annot, String id, Set<String> pages, String annotId, String popupId, Set<String> formXObjects) {
        this.annot = annot;
        this.id = id;
        this.pages = pages;
        this.annotId = annotId;
        this.popupId = popupId;
        this.formXObjects = formXObjects;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.ANNOTATION;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.annot != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("annotation");
            root.setAttribute(ID, this.id);
            this.addParents(root);
            PBCreateNodeHelper.addNotEmptyNode("subType", this.annot.getSubtype(), root);
            PBCreateNodeHelper.addBoxFeature("rectangle", this.annot.getRectangle(), root);
            PBCreateNodeHelper.addNotEmptyNode("contents", this.annot.getContents(), root);
            PBCreateNodeHelper.addNotEmptyNode("annotationName", this.annot.getAnnotationName(), root);
            PBCreateNodeHelper.addNotEmptyNode("modifiedDate", this.annot.getModifiedDate(), root);
            if (this.formXObjects != null && !this.formXObjects.isEmpty()) {
                FeatureTreeNode resources = FeatureTreeNode.createChildNode("resources", root);
                for (String xObjID : this.formXObjects) {
                    if (xObjID == null) continue;
                    FeatureTreeNode xObjNode = FeatureTreeNode.createChildNode("xobject", resources);
                    xObjNode.setAttribute(ID, xObjID);
                }
            }
            if (this.popupId != null) {
                FeatureTreeNode popup = FeatureTreeNode.createChildNode("popup", root);
                popup.setAttribute(ID, this.popupId);
            }
            PBCreateNodeHelper.addDeviceColorSpaceNode("color", this.annot.getColor(), root, collection);
            PBCreateNodeHelper.addNotEmptyNode("invisible", String.valueOf(this.annot.isInvisible()), root);
            PBCreateNodeHelper.addNotEmptyNode("hidden", String.valueOf(this.annot.isHidden()), root);
            PBCreateNodeHelper.addNotEmptyNode("print", String.valueOf(this.annot.isPrinted()), root);
            PBCreateNodeHelper.addNotEmptyNode("noZoom", String.valueOf(this.annot.isNoZoom()), root);
            PBCreateNodeHelper.addNotEmptyNode("noRotate", String.valueOf(this.annot.isNoRotate()), root);
            PBCreateNodeHelper.addNotEmptyNode("noView", String.valueOf(this.annot.isNoView()), root);
            PBCreateNodeHelper.addNotEmptyNode("readOnly", String.valueOf(this.annot.isReadOnly()), root);
            PBCreateNodeHelper.addNotEmptyNode("locked", String.valueOf(this.annot.isLocked()), root);
            PBCreateNodeHelper.addNotEmptyNode("toggleNoView", String.valueOf(this.annot.isToggleNoView()), root);
            boolean lockedContents = (this.annot.getAnnotationFlags() & 0x200) == 512;
            PBCreateNodeHelper.addNotEmptyNode("lockedContents", String.valueOf(lockedContents), root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.ANNOTATION, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private void addParents(FeatureTreeNode root) throws FeatureParsingException {
        if (this.pages != null && !this.pages.isEmpty() || this.annotId != null) {
            FeatureTreeNode parents = FeatureTreeNode.createChildNode("parents", root);
            if (this.pages != null) {
                for (String page : this.pages) {
                    if (page == null) continue;
                    FeatureTreeNode pageNode = FeatureTreeNode.createChildNode("page", parents);
                    pageNode.setAttribute(ID, page);
                }
            }
            if (this.annotId != null) {
                FeatureTreeNode annotNode = FeatureTreeNode.createChildNode("annotation", parents);
                annotNode.setAttribute(ID, this.annotId);
            }
        }
    }
}

