/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.ImageFeaturesData;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBImageXObjectFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBImageXObjectFeaturesObject.class);
    private static final String ID = "id";
    private PDImageXObjectProxy imageXObject;
    private String id;
    private String colorSpaceChild;
    private String maskChild;
    private String sMaskChild;
    private Set<String> alternatesChild;
    private Set<String> pageParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBImageXObjectFeaturesObject(PDImageXObjectProxy imageXObject, String id, String colorSpaceChild, String maskChild, String sMaskChild, Set<String> alternatesChild, Set<String> pageParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.imageXObject = imageXObject;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
        this.maskChild = maskChild;
        this.sMaskChild = sMaskChild;
        this.alternatesChild = alternatesChild;
        this.pageParent = pageParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.IMAGE_XOBJECT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.imageXObject != null) {
            FeatureTreeNode mask;
            FeatureTreeNode root = FeatureTreeNode.createRootNode("xobject");
            root.setAttribute("type", "image");
            root.setAttribute(ID, this.id);
            this.parseParents(root);
            FeatureTreeNode.createChildNode("width", root).setValue(String.valueOf(this.imageXObject.getWidth()));
            FeatureTreeNode.createChildNode("height", root).setValue(String.valueOf(this.imageXObject.getHeight()));
            if (this.colorSpaceChild != null) {
                FeatureTreeNode shading = FeatureTreeNode.createChildNode("colorSpace", root);
                shading.setAttribute(ID, this.colorSpaceChild);
            }
            FeatureTreeNode.createChildNode("bitsPerComponent", root).setValue(String.valueOf(this.imageXObject.getBitsPerComponent()));
            FeatureTreeNode.createChildNode("imageMask", root).setValue(String.valueOf(this.imageXObject.isStencil()));
            if (this.maskChild != null) {
                mask = FeatureTreeNode.createChildNode("mask", root);
                mask.setAttribute(ID, this.maskChild);
            }
            FeatureTreeNode.createChildNode("interpolate", root).setValue(String.valueOf(this.imageXObject.getInterpolate()));
            PBCreateNodeHelper.parseIDSet(this.alternatesChild, "alternate", "alternates", root);
            if (this.sMaskChild != null) {
                mask = FeatureTreeNode.createChildNode("sMask", root);
                mask.setAttribute(ID, this.sMaskChild);
            }
            if (this.imageXObject.getCOSStream().getItem(COSName.STRUCT_PARENT) != null) {
                FeatureTreeNode.createChildNode("structParent", root).setValue(String.valueOf(this.imageXObject.getStructParent()));
            }
            try {
                if (this.imageXObject.getStream().getFilters() != null && !this.imageXObject.getStream().getFilters().isEmpty()) {
                    FeatureTreeNode filters = FeatureTreeNode.createChildNode("filters", root);
                    for (COSName name : this.imageXObject.getStream().getFilters()) {
                        PBCreateNodeHelper.addNotEmptyNode("filter", name.getName(), filters);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.info(e);
            }
            PBCreateNodeHelper.parseMetadata(this.imageXObject.getMetadata(), "metadata", root, collection);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.IMAGE_XOBJECT, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        try {
            byte[] stream = PBCreateNodeHelper.inputStreamToByteArray(this.imageXObject.getCOSStream().getFilteredStream());
            byte[] metadata = null;
            if (this.imageXObject.getMetadata() != null) {
                try {
                    metadata = PBCreateNodeHelper.inputStreamToByteArray(this.imageXObject.getMetadata().getStream().getUnfilteredStream());
                }
                catch (IOException e) {
                    LOGGER.error("Can not get metadata stream for image xobject", e);
                }
            }
            ArrayList<ImageFeaturesData.Filter> filters = new ArrayList<ImageFeaturesData.Filter>();
            if (this.imageXObject.getPDStream().getFilters() != null) {
                ArrayList<String> filtersNames = new ArrayList<String>();
                for (COSName filter : this.imageXObject.getPDStream().getFilters()) {
                    filtersNames.add(filter.getName());
                }
                List<COSDictionary> decodeList = PBImageXObjectFeaturesObject.getDecodeList(this.imageXObject.getCOSStream().getDictionaryObject(COSName.DECODE_PARMS));
                block21: for (int i = 0; i < filtersNames.size(); ++i) {
                    String filter = (String)filtersNames.get(i);
                    COSDictionary dic = i < decodeList.size() ? decodeList.get(i) : null;
                    switch (filter) {
                        case "LZWDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance(filter, PBImageXObjectFeaturesObject.getLZWOrFlatFiltersMap(dic, true), null));
                            continue block21;
                        }
                        case "FlateDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance(filter, PBImageXObjectFeaturesObject.getLZWOrFlatFiltersMap(dic, false), null));
                            continue block21;
                        }
                        case "CCITTFaxDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance(filter, PBImageXObjectFeaturesObject.getCCITTFaxFiltersMap(dic), null));
                            continue block21;
                        }
                        case "DCTDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance(filter, PBImageXObjectFeaturesObject.getDCTFiltersMap(dic), null));
                            continue block21;
                        }
                        case "JBIG2Decode": {
                            byte[] global = null;
                            if (dic != null && dic.getDictionaryObject(COSName.JBIG2_GLOBALS) instanceof COSStream) {
                                global = PBCreateNodeHelper.inputStreamToByteArray(((COSStream)dic.getDictionaryObject(COSName.JBIG2_GLOBALS)).getUnfilteredStream());
                            }
                            filters.add(ImageFeaturesData.Filter.newInstance(filter, new HashMap<String, String>(), global));
                            continue block21;
                        }
                        case "Crypt": {
                            if (dic == null || !COSName.IDENTITY.equals(dic.getCOSName(COSName.NAME))) {
                                LOGGER.error("An Image has a Crypt filter");
                                return null;
                            }
                        }
                        default: {
                            filters.add(ImageFeaturesData.Filter.newInstance(filter, new HashMap<String, String>(), null));
                        }
                    }
                }
            }
            Integer width = PBImageXObjectFeaturesObject.getIntegerWithDefault(this.imageXObject.getCOSStream().getDictionaryObject(COSName.WIDTH), null);
            Integer height = PBImageXObjectFeaturesObject.getIntegerWithDefault(this.imageXObject.getCOSStream().getDictionaryObject(COSName.HEIGHT), null);
            return ImageFeaturesData.newInstance(metadata, stream, width, height, filters);
        }
        catch (IOException e) {
            LOGGER.error("Error in obtaining features data for fonts", e);
            return null;
        }
    }

    private static List<COSDictionary> getDecodeList(COSBase base) {
        ArrayList<COSDictionary> res = new ArrayList<COSDictionary>();
        if (base instanceof COSDictionary) {
            res.add((COSDictionary)base);
        } else if (base instanceof COSArray) {
            for (COSBase baseElem : (COSArray)base) {
                if (baseElem instanceof COSDictionary) {
                    res.add((COSDictionary)baseElem);
                    continue;
                }
                res.add(null);
            }
        }
        return res;
    }

    private static Map<String, String> getCCITTFaxFiltersMap(COSDictionary base) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (base != null) {
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "K", base.getDictionaryObject(COSName.K), 0);
            PBImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EndOfLine", base.getDictionaryObject(COSName.COLORS), false);
            PBImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EncodedByteAlign", base.getDictionaryObject(COSName.BITS_PER_COMPONENT), false);
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Columns", base.getDictionaryObject(COSName.COLUMNS), 1728);
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Rows", base.getDictionaryObject(COSName.ROWS), 0);
            PBImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EndOfBlock", base.getDictionaryObject(COSName.getPDFName("EndOfBlock")), true);
            PBImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "BlackIs1", base.getDictionaryObject(COSName.BLACK_IS_1), false);
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "DamagedRowsBeforeError", base.getDictionaryObject(COSName.getPDFName("DamagedRowsBeforeError")), 0);
        } else {
            res.put("K", "0");
            res.put("EndOfLine", "false");
            res.put("EncodedByteAlign", "false");
            res.put("Columns", "1728");
            res.put("Rows", "0");
            res.put("EndOfBlock", "true");
            res.put("BlackIs1", "false");
            res.put("DamagedRowsBeforeError", "0");
        }
        return res;
    }

    private static Map<String, String> getDCTFiltersMap(COSDictionary base) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (base != null && base.getDictionaryObject(COSName.getPDFName("ColorTransform")) != null && base.getDictionaryObject(COSName.getPDFName("ColorTransform")) instanceof COSInteger) {
            res.put("ColorTransform", String.valueOf(((COSInteger)base.getDictionaryObject(COSName.getPDFName("ColorTransform"))).intValue()));
        }
        return res;
    }

    private static Map<String, String> getLZWOrFlatFiltersMap(COSDictionary base, boolean isLZW) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (base != null) {
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Predictor", base.getDictionaryObject(COSName.PREDICTOR), 1);
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Colors", base.getDictionaryObject(COSName.COLORS), 1);
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "BitsPerComponent", base.getDictionaryObject(COSName.BITS_PER_COMPONENT), 8);
            PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Columns", base.getDictionaryObject(COSName.COLUMNS), 1);
            if (isLZW) {
                PBImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "EarlyChange", base.getDictionaryObject(COSName.EARLY_CHANGE), 1);
            }
        } else {
            res.put("Predictor", "1");
            res.put("Colors", "1");
            res.put("BitsPerComponent", "8");
            res.put("Columns", "1");
            if (isLZW) {
                res.put("EarlyChange", "1");
            }
        }
        return res;
    }

    private static Integer getIntegerWithDefault(Object value, Integer defaultValue) {
        if (value instanceof COSInteger) {
            return ((COSInteger)value).intValue();
        }
        return defaultValue;
    }

    private static void putIntegerAsStringWithDefault(Map<String, String> map, String key, Object value, Integer defaultValue) {
        if (value instanceof COSInteger) {
            map.put(key, String.valueOf(((COSInteger)value).intValue()));
        } else if (defaultValue != null) {
            map.put(key, defaultValue.toString());
        }
    }

    private static void putBooleanAsStringWithDefault(Map<String, String> map, String key, Object value, Boolean defaultValue) {
        if (value instanceof COSBoolean) {
            map.put(key, String.valueOf(((COSBoolean)value).getValue()));
        } else if (defaultValue != null) {
            map.put(key, defaultValue.toString());
        }
    }

    private void parseParents(FeatureTreeNode root) throws FeatureParsingException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.createChildNode("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }
}

