/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDPage;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBPageFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDPage page;
    private String thumb;
    private Set<String> annotsId;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private String id;
    private int index;

    public PBPageFeaturesObject(PDPage page, String thumb, Set<String> annotsId, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild, String id, int index) {
        this.page = page;
        this.thumb = thumb;
        this.annotsId = annotsId;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        this.id = id;
        this.index = index;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.PAGE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.page != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("page");
            root.setAttribute(ID, this.id);
            root.setAttribute("orderNumber", Integer.toString(this.index));
            PBCreateNodeHelper.addBoxFeature("mediaBox", this.page.getMediaBox(), root);
            PBCreateNodeHelper.addBoxFeature("cropBox", this.page.getCropBox(), root);
            PBCreateNodeHelper.addBoxFeature("trimBox", this.page.getTrimBox(), root);
            PBCreateNodeHelper.addBoxFeature("bleedBox", this.page.getBleedBox(), root);
            PBCreateNodeHelper.addBoxFeature("artBox", this.page.getArtBox(), root);
            FeatureTreeNode.createChildNode("rotation", root).setValue(String.valueOf(this.page.getRotation()));
            COSBase base = this.page.getCOSObject().getDictionaryObject(COSName.getPDFName("PZ"));
            if (base != null) {
                FeatureTreeNode scaling = FeatureTreeNode.createChildNode("scaling", root);
                while (base instanceof COSObject) {
                    base = ((COSObject)base).getObject();
                }
                if (base instanceof COSNumber) {
                    COSNumber number = (COSNumber)base;
                    scaling.setValue(String.valueOf(number.doubleValue()));
                } else {
                    ErrorsHelper.addErrorIntoCollection(collection, scaling, "Scaling is not a number");
                }
            }
            if (this.thumb != null) {
                FeatureTreeNode thumbNode = FeatureTreeNode.createChildNode("thumbnail", root);
                thumbNode.setAttribute(ID, this.thumb);
            }
            PBCreateNodeHelper.parseMetadata(this.page.getMetadata(), "metadata", root, collection);
            PBCreateNodeHelper.parseIDSet(this.annotsId, "annotation", "annotations", root);
            this.parseResources(root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.PAGE, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = FeatureTreeNode.createChildNode("resources", root);
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

