/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import org.verapdf.gui.LogoPanel;
import org.verapdf.gui.ValidateWorker;
import org.verapdf.gui.tools.GUIConstants;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.processor.ProcessingResult;
import org.verapdf.processor.config.Config;
import org.verapdf.processor.config.ConfigIO;
import org.verapdf.processor.config.ProcessingType;

class CheckerPanel
extends JPanel {
    private static final long serialVersionUID = 1290058869994329766L;
    private static final Logger LOGGER = Logger.getLogger(CheckerPanel.class);
    private JFileChooser pdfChooser;
    private JFileChooser xmlChooser;
    private JFileChooser htmlChooser;
    private File pdfFile;
    private JTextField chosenPDF;
    private JTextField chosenProfile;
    private JLabel resultLabel;
    private File xmlReport;
    private File htmlReport;
    private JComboBox<ProcessingType> processingType;
    private JCheckBox fixMetadata;
    private JComboBox<PDFAFlavour> chooseFlavour;
    private boolean isValidationErrorOccurred;
    private JButton validate;
    private JButton saveXML;
    private JButton viewXML;
    private JButton saveHTML;
    private JButton viewHTML;
    private transient Config config;
    JProgressBar progressBar;
    transient ValidateWorker validateWorker;

    CheckerPanel(Config config) throws IOException {
        this.config = config;
        this.setPreferredSize(new Dimension(450, 200));
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        this.chosenPDF = new JTextField("PDF file not chosen");
        this.chosenPDF.setEditable(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 0, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.chosenPDF, gbc);
        this.add(this.chosenPDF);
        JButton choosePDF = new JButton("Choose PDF");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 0, 0, 1, 1, 1, 2);
        gbl.setConstraints(choosePDF, gbc);
        this.add(choosePDF);
        JLabel processType = new JLabel(" Report type: ");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 2, 0, 1, 1, 1, 2);
        gbl.setConstraints(processType, gbc);
        this.add(processType);
        this.processingType = new JComboBox<ProcessingType>(ProcessingType.values());
        this.processingType.setSelectedItem((Object)config.getProcessingType());
        ProcessingTypeRenderer processingTypeRenderer = new ProcessingTypeRenderer();
        this.processingType.setRenderer(processingTypeRenderer);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 1, 2, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.processingType, gbc);
        this.add(this.processingType);
        this.fixMetadata = new JCheckBox("Fix metadata");
        this.fixMetadata.setSelected(config.isFixMetadata());
        CheckerPanel.setGridBagConstraintsParameters(gbc, 2, 2, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.fixMetadata, gbc);
        this.add(this.fixMetadata);
        if (config.getProcessingType() == ProcessingType.FEATURES) {
            this.fixMetadata.setEnabled(false);
        }
        Vector<PDFAFlavour> availableFlavours = new Vector<PDFAFlavour>();
        availableFlavours.add(PDFAFlavour.NO_FLAVOUR);
        availableFlavours.add(PDFAFlavour.AUTO);
        for (PDFAFlavour flavour : PDFAFlavour.values()) {
            Set<PDFAFlavour> currentFlavours = Profiles.getVeraProfileDirectory().getPDFAFlavours();
            if (!currentFlavours.contains((Object)flavour)) continue;
            availableFlavours.add(flavour);
        }
        this.chooseFlavour = new JComboBox(availableFlavours);
        ChooseFlavourRenderer renderer = new ChooseFlavourRenderer();
        this.chooseFlavour.setRenderer(renderer);
        this.chooseFlavour.setSelectedItem((Object)PDFAFlavour.PDFA_1_B);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 2, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.chooseFlavour, gbc);
        this.add(this.chooseFlavour);
        this.chosenProfile = new JTextField("Validation profile not chosen");
        this.chosenProfile.setEditable(false);
        this.chosenProfile.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 1, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.chosenProfile, gbc);
        this.add(this.chosenProfile);
        if (!this.config.getValidationProfile().toString().equals("")) {
            this.chosenProfile.setText(this.config.getValidationProfile().toAbsolutePath().toString());
        } else {
            this.chosenProfile.setText("Please, specify validation profile");
        }
        final JButton chooseProfile = new JButton("Choose Profile");
        chooseProfile.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 1, 0, 1, 1, 1, 2);
        gbl.setConstraints(chooseProfile, gbc);
        this.add(chooseProfile);
        this.resultLabel = new JLabel();
        this.resultLabel.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
        this.resultLabel.setHorizontalTextPosition(0);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 3, 3, 1, 3, 1, 10);
        gbl.setConstraints(this.resultLabel, gbc);
        this.add(this.resultLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 3, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.progressBar, gbc);
        this.add(this.progressBar);
        this.validate = new JButton("Execute");
        this.validate.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.validate, gbc);
        this.add(this.validate);
        JPanel reports = new JPanel();
        reports.setBorder(BorderFactory.createTitledBorder("Report"));
        reports.setLayout(new GridLayout(2, 3));
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 4, 4, 3, 4, 1, 2);
        gbl.setConstraints(reports, gbc);
        this.add(reports);
        LogoPanel xmlLogo = new LogoPanel("xml-logo.png", reports.getBackground(), 4);
        reports.add(xmlLogo);
        this.saveXML = new JButton("Save XML");
        this.saveXML.setEnabled(false);
        reports.add(this.saveXML);
        this.viewXML = new JButton("View XML");
        this.viewXML.setEnabled(false);
        reports.add(this.viewXML);
        LogoPanel htmlLogo = new LogoPanel("html-logo.png", reports.getBackground(), 4);
        reports.add(htmlLogo);
        this.saveHTML = new JButton("Save HTML");
        this.saveHTML.setEnabled(false);
        gbc.fill = 2;
        reports.add(this.saveHTML);
        this.viewHTML = new JButton("View HTML");
        this.viewHTML.setEnabled(false);
        reports.add(this.viewHTML);
        this.pdfChooser = CheckerPanel.getChooser("pdf");
        this.xmlChooser = CheckerPanel.getChooser("xml");
        this.htmlChooser = CheckerPanel.getChooser("html");
        choosePDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.pdfChooser, "pdf");
            }
        });
        this.processingType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessingType item = (ProcessingType)((Object)CheckerPanel.this.processingType.getSelectedItem());
                switch (item) {
                    case VALIDATING: {
                        CheckerPanel.this.fixMetadata.setEnabled(true);
                        break;
                    }
                    case VALIDATING_AND_FEATURES: {
                        CheckerPanel.this.fixMetadata.setEnabled(true);
                        break;
                    }
                    case FEATURES: {
                        CheckerPanel.this.fixMetadata.setEnabled(false);
                        break;
                    }
                }
            }
        });
        this.chooseFlavour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckerPanel.this.config.setFlavour((PDFAFlavour)((Object)CheckerPanel.this.chooseFlavour.getSelectedItem()));
                if (CheckerPanel.this.chooseFlavour.getSelectedItem() == PDFAFlavour.NO_FLAVOUR) {
                    chooseProfile.setEnabled(true);
                    CheckerPanel.this.chosenProfile.setEnabled(true);
                } else if (CheckerPanel.this.chooseFlavour.getSelectedItem() != PDFAFlavour.NO_FLAVOUR) {
                    chooseProfile.setEnabled(false);
                    CheckerPanel.this.chosenProfile.setEnabled(false);
                }
                CheckerPanel.this.setValidationButtonEnability();
            }
        });
        chooseProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.xmlChooser, "xml");
            }
        });
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CheckerPanel.this.changeConfig();
                    CheckerPanel.this.validateWorker = new ValidateWorker(CheckerPanel.this, CheckerPanel.this.pdfFile, CheckerPanel.this.config);
                    CheckerPanel.this.progressBar.setVisible(true);
                    CheckerPanel.this.resultLabel.setVisible(false);
                    CheckerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    CheckerPanel.this.validate.setEnabled(false);
                    CheckerPanel.this.isValidationErrorOccurred = false;
                    CheckerPanel.this.viewXML.setEnabled(false);
                    CheckerPanel.this.saveXML.setEnabled(false);
                    CheckerPanel.this.viewHTML.setEnabled(false);
                    CheckerPanel.this.saveHTML.setEnabled(false);
                    CheckerPanel.this.validateWorker.execute();
                }
                catch (IllegalArgumentException exep) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, exep.getMessage(), "Error", 0);
                    LOGGER.error(exep);
                }
            }
        });
        this.saveXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.xmlChooser, "xml", CheckerPanel.this.xmlReport);
            }
        });
        this.saveHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.htmlChooser, "html", CheckerPanel.this.htmlReport);
            }
        });
        this.viewXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.xmlReport == null) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "XML report hasn't been saved.", "Error", 0);
                } else {
                    this.openXMLReport();
                }
            }

            private void openXMLReport() {
                try {
                    Desktop.getDesktop().open(CheckerPanel.this.xmlReport);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "Some error in opening the XML report.", "Error", 0);
                    LOGGER.error("Exception in opening the XML report", e1);
                }
            }
        });
        this.viewHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.htmlReport == null) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "HTML report hasn't been saved.", "Error", 0);
                } else {
                    try {
                        Desktop.getDesktop().open(CheckerPanel.this.htmlReport);
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(CheckerPanel.this, "Some error in opening the HTML report.", "Error", 0);
                        LOGGER.error("Exception in opening the HTML report", e1);
                    }
                }
            }
        });
    }

    void validationEnded(File xmlReport, File htmlReport) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        this.validate.setEnabled(true);
        if (!this.isValidationErrorOccurred) {
            try {
                ProcessingResult result = (ProcessingResult)this.validateWorker.get();
                ProcessingResult.ValidationSummary validationSummary = result.getValidationSummary();
                List<String> errorMessages = result.getErrorMessages();
                if (!errorMessages.isEmpty() && validationSummary != ProcessingResult.ValidationSummary.FILE_VALID && validationSummary != ProcessingResult.ValidationSummary.FILE_NOT_VALID) {
                    this.resultLabel.setForeground(GUIConstants.VALIDATION_FAILED_COLOR);
                    this.resultLabel.setText(errorMessages.get(0));
                }
                if (validationSummary == ProcessingResult.ValidationSummary.FILE_VALID) {
                    this.resultLabel.setForeground(GUIConstants.VALIDATION_SUCCESS_COLOR);
                    this.resultLabel.setText("PDF file is compliant with Validation Profile requirements");
                } else if (validationSummary == ProcessingResult.ValidationSummary.FILE_NOT_VALID) {
                    this.resultLabel.setForeground(GUIConstants.VALIDATION_FAILED_COLOR);
                    this.resultLabel.setText("PDF file is not compliant with Validation Profile requirements");
                } else if (errorMessages.isEmpty()) {
                    this.resultLabel.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
                    this.resultLabel.setText("Features report generating finished correctly");
                }
                this.resultLabel.setVisible(true);
                this.xmlReport = xmlReport;
                this.htmlReport = htmlReport;
                if (xmlReport != null) {
                    this.saveXML.setEnabled(true);
                    this.viewXML.setEnabled(true);
                }
                if (htmlReport != null) {
                    this.saveHTML.setEnabled(true);
                    this.viewHTML.setEnabled(true);
                }
            }
            catch (InterruptedException e) {
                this.errorInValidatingOccur("Process has been interrupted: ", e);
            }
            catch (ExecutionException e) {
                this.errorInValidatingOccur("Execution exception in processing: ", e);
            }
        }
    }

    void errorInValidatingOccur(String message, Throwable e) {
        LOGGER.error(e);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        this.isValidationErrorOccurred = true;
        JOptionPane.showMessageDialog(this, message + e.getMessage(), "Error", 0);
        this.resultLabel.setForeground(GUIConstants.VALIDATION_FAILED_COLOR);
        this.resultLabel.setText(message + e.getMessage());
        this.resultLabel.setVisible(true);
    }

    private static JFileChooser getChooser(String type) throws IOException {
        JFileChooser res = new JFileChooser();
        File currentDir = new File(new File(".").getCanonicalPath());
        res.setCurrentDirectory(currentDir);
        res.setAcceptAllFileFilterUsed(false);
        res.setFileFilter(new FileNameExtensionFilter(type, type));
        return res;
    }

    private static void setGridBagConstraintsParameters(GridBagConstraints gbc, int gridx, int gridy, int weightx, int weighty, int gridwidth, int gridheight, int fill) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
    }

    private void chooseFile(JFileChooser chooser, String extension) {
        int resultChoose = chooser.showOpenDialog(this);
        if (resultChoose == 0) {
            if (!chooser.getSelectedFile().exists()) {
                JOptionPane.showMessageDialog(this, "Error. Selected file doesn't exist.", "Error", 0);
            } else if (!chooser.getSelectedFile().getName().toLowerCase().endsWith("." + extension.toLowerCase())) {
                JOptionPane.showMessageDialog(this, "Error. Selected file is not in " + extension.toUpperCase() + " format.", "Error", 0);
            } else {
                this.resultLabel.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
                this.resultLabel.setText("");
                this.xmlReport = null;
                this.htmlReport = null;
                this.saveXML.setEnabled(false);
                this.viewXML.setEnabled(false);
                this.saveHTML.setEnabled(false);
                this.viewHTML.setEnabled(false);
                switch (extension) {
                    case "pdf": {
                        this.pdfFile = chooser.getSelectedFile();
                        this.chosenPDF.setText(this.pdfFile.getAbsolutePath());
                        break;
                    }
                    case "xml": {
                        this.config.setValidationProfilePath(chooser.getSelectedFile().toPath().toAbsolutePath());
                        this.chosenProfile.setText(this.config.getValidationProfile().toString());
                        break;
                    }
                }
                this.setValidationButtonEnability();
            }
        }
    }

    private void saveReport(JFileChooser chooser, String extension, File report) {
        if (report == null) {
            JOptionPane.showMessageDialog(this, "Validation hasn't been run.", "Error", 0);
        } else {
            chooser.setSelectedFile(new File(extension.toLowerCase() + "Report." + extension.toLowerCase()));
            int resultChoose = chooser.showSaveDialog(this);
            if (resultChoose == 0) {
                File temp = chooser.getSelectedFile();
                if (!temp.getName().toLowerCase().endsWith("." + extension.toLowerCase())) {
                    temp = new File(temp.getPath() + "." + extension.toLowerCase());
                }
                try {
                    try {
                        Files.copy(report.toPath(), temp.toPath(), new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e1) {
                        LOGGER.debug("File already exists, conform overwrite with user", e1);
                        int resultOption = JOptionPane.showConfirmDialog(this, extension.toUpperCase() + " file with the same name already exists. Do you want to overwrite it?", "", 0);
                        if (resultOption == 0) {
                            Files.copy(report.toPath(), temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Some error in saving the HTML report: " + e.getMessage(), "Error", 0);
                    LOGGER.error("Exception saving " + extension.toUpperCase() + " report", e);
                }
            }
        }
    }

    private void changeConfig() {
        if (this.chooseFlavour.getSelectedItem() != PDFAFlavour.NO_FLAVOUR) {
            this.config.setValidationProfilePath(FileSystems.getDefault().getPath("", new String[0]));
        }
        this.config.setProcessingType((ProcessingType)((Object)this.processingType.getSelectedItem()));
        this.config.setFixMetadata(this.fixMetadata.isSelected());
        this.config.setFlavour((PDFAFlavour)((Object)this.chooseFlavour.getSelectedItem()));
        ConfigIO.writeConfig(this.config);
    }

    private void setValidationButtonEnability() {
        if (!(this.pdfFile == null || this.config.getValidationProfile().toString().equals("") && this.chooseFlavour.getSelectedItem() == PDFAFlavour.NO_FLAVOUR)) {
            this.validate.setEnabled(true);
        } else {
            this.validate.setEnabled(false);
        }
    }

    boolean isFixMetadata() {
        return this.fixMetadata.isSelected();
    }

    ProcessingType getProcessingType() {
        return (ProcessingType)((Object)this.processingType.getSelectedItem());
    }

    private class ProcessingTypeRenderer
    extends JLabel
    implements ListCellRenderer<ProcessingType> {
        public ProcessingTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ProcessingType> list, ProcessingType value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toText());
            return this;
        }
    }

    private class ChooseFlavourRenderer
    extends JLabel
    implements ListCellRenderer<PDFAFlavour> {
        public ChooseFlavourRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PDFAFlavour> list, PDFAFlavour value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == PDFAFlavour.NO_FLAVOUR) {
                this.setText("Custom profile");
                return this;
            }
            if (value == PDFAFlavour.AUTO) {
                this.setText("Auto-detection");
                return this;
            }
            if (value.toString().matches("\\d\\w")) {
                String valueString = value.toString();
                String parsedFlavour = "PDF/A-";
                parsedFlavour = parsedFlavour + valueString.charAt(0);
                parsedFlavour = parsedFlavour + valueString.substring(1, 2).toUpperCase();
                this.setText(parsedFlavour);
                return this;
            }
            this.setText("Error in parsing flavour");
            return this;
        }
    }
}

