/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.schemas.AdobePDF;
import org.verapdf.metadata.fixer.schemas.BasicSchema;
import org.verapdf.metadata.fixer.schemas.DublinCore;
import org.verapdf.metadata.fixer.schemas.XMPBasic;
import org.verapdf.metadata.fixer.utils.DateConverter;
import org.verapdf.metadata.fixer.utils.FixerConfig;
import org.verapdf.metadata.fixer.utils.ProcessedObjectsInspector;
import org.verapdf.metadata.fixer.utils.ValidationStatus;
import org.verapdf.pdfa.MetadataFixer;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.MetadataFixerResultImpl;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.ProfileDirectory;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.xml.sax.SAXException;

public abstract class MetadataFixerImpl
implements MetadataFixer {
    private static final ProfileDirectory PROFILES = Profiles.getVeraProfileDirectory();
    private static final Logger LOGGER = Logger.getLogger(MetadataFixerImpl.class);
    private static final Map<String, String> attributes = new HashMap<String, String>(8);

    protected MetadataFixerImpl() {
    }

    public static MetadataFixerResult fixMetadata(OutputStream output, FixerConfig config) {
        ValidationResult result = config.getValidationResult();
        return result != null && result.isCompliant() ? new MetadataFixerResultImpl.Builder().build() : MetadataFixerImpl.fixAndSaveDocument(output, config);
    }

    private static MetadataFixerResult fixAndSaveDocument(OutputStream output, FixerConfig config) {
        try {
            Metadata metadata = config.getDocument().getMetadata();
            if (metadata != null) {
                MetadataFixerResultImpl.Builder resultBuilder = new MetadataFixerResultImpl.Builder();
                ValidationStatus status = MetadataFixerImpl.getValidationStatus(config);
                switch (status) {
                    case INVALID_METADATA: {
                        MetadataFixerImpl.executeInvalidMetadataCase(config, metadata, resultBuilder);
                        break;
                    }
                    case INVALID_DOCUMENT: 
                    case INVALID_STRUCTURE: {
                        resultBuilder.status(MetadataFixerResult.RepairStatus.WONT_FIX);
                        if (!config.isFixIdentification()) break;
                        metadata.removePDFIdentificationSchema(resultBuilder, config.getValidationResult().getPDFAFlavour());
                        break;
                    }
                }
                MetadataFixerImpl.updateModificationDate(config, resultBuilder);
                MetadataFixerResult partialResult = config.getDocument().saveDocumentIncremental(resultBuilder.getStatus(), output);
                resultBuilder.status(partialResult.getRepairStatus());
                for (String fix : partialResult.getAppliedFixes()) {
                    resultBuilder.addFix(fix);
                }
                return resultBuilder.build();
            }
            return MetadataFixerImpl.getErrorResult("Problems with metadata obtain. No possibility to fix metadata.");
        }
        catch (Exception e) {
            LOGGER.error(e);
            return MetadataFixerImpl.getErrorResult("Error while fixing metadata: " + e.getMessage());
        }
    }

    private static MetadataFixerResult getErrorResult(String message) {
        MetadataFixerResultImpl.Builder resultBuilder = new MetadataFixerResultImpl.Builder();
        resultBuilder.status(MetadataFixerResult.RepairStatus.FIX_ERROR).addFix(message);
        return resultBuilder.build();
    }

    private static ValidationStatus getValidationStatus(FixerConfig config) {
        ValidationResult result = config.getValidationResult();
        ValidationProfile profile = PROFILES.getValidationProfileByFlavour(config.getValidationResult().getPDFAFlavour());
        if (profile != null) {
            try {
                return ProcessedObjectsInspector.validationStatus(result.getTestAssertions(), profile, config.getParser());
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
                LOGGER.error("Problem with validation status obtain. Validation status set as Invalid Document.");
                LOGGER.error(e);
                return ValidationStatus.INVALID_DOCUMENT;
            }
        }
        LOGGER.error("Problem with validation status obtain. Validation status set as Invalid Metadata.");
        return ValidationStatus.INVALID_METADATA;
    }

    private static void executeInvalidMetadataCase(FixerConfig config, Metadata metadata, MetadataFixerResultImpl.Builder resultBuilder) {
        int removedFilters;
        if (config.getValidationResult().getPDFAFlavour().getPart() == PDFAFlavour.Specification.ISO_19005_1 && (removedFilters = config.getDocument().removeFiltersForAllMetadataObjects()) > 0) {
            resultBuilder.addFix("Metadata streams unfiltered");
        }
        MetadataFixerImpl.fixMetadata(resultBuilder, config);
        if (config.isFixIdentification()) {
            metadata.addPDFIdentificationSchema(resultBuilder, config.getValidationResult().getPDFAFlavour());
        }
        if (metadata.isNeedToBeUpdated()) {
            metadata.checkMetadataStream(resultBuilder, config.getValidationResult().getPDFAFlavour());
        }
    }

    private static void fixMetadata(MetadataFixerResultImpl.Builder resultBuilder, FixerConfig config) {
        PDFAFlavour pdfaFlavour = config.getValidationResult().getPDFAFlavour();
        if (pdfaFlavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
            MetadataFixerImpl.fixDublinCoreSchema(resultBuilder, config);
            MetadataFixerImpl.fixAdobePDFSchema(resultBuilder, config);
            MetadataFixerImpl.fixBasicXMLSchema(resultBuilder, config);
        }
    }

    private static void fixDublinCoreSchema(MetadataFixerResultImpl.Builder resultBuilder, FixerConfig config) {
        InfoDictionary info;
        Metadata metadata = config.getDocument().getMetadata();
        DublinCore schema = metadata.getDublinCoreSchema(info = config.getDocument().getInfoDictionary());
        if (schema != null && info != null) {
            MetadataFixerImpl.fixProperty(resultBuilder, schema, info, schema.getTitle(), info.getTitle(), "title");
            MetadataFixerImpl.fixProperty(resultBuilder, schema, info, schema.getSubject(), info.getSubject(), "description");
            MetadataFixerImpl.fixProperty(resultBuilder, schema, info, schema.getAuthor(), info.getAuthor(), "creator");
        }
    }

    private static void fixAdobePDFSchema(MetadataFixerResultImpl.Builder resultBuilder, FixerConfig config) {
        InfoDictionary info;
        Metadata metadata = config.getDocument().getMetadata();
        AdobePDF schema = metadata.getAdobePDFSchema(info = config.getDocument().getInfoDictionary());
        if (schema != null && info != null) {
            MetadataFixerImpl.fixProperty(resultBuilder, schema, info, schema.getProducer(), info.getProducer(), "Producer");
            MetadataFixerImpl.fixProperty(resultBuilder, schema, info, schema.getKeywords(), info.getKeywords(), "Keywords");
        }
    }

    private static void fixBasicXMLSchema(MetadataFixerResultImpl.Builder resultBuilder, FixerConfig config) {
        InfoDictionary info;
        Metadata metadata = config.getDocument().getMetadata();
        XMPBasic schema = metadata.getXMPBasicSchema(info = config.getDocument().getInfoDictionary());
        if (schema != null && info != null) {
            MetadataFixerImpl.fixProperty(resultBuilder, schema, info, schema.getCreator(), info.getCreator(), "CreatorTool");
            MetadataFixerImpl.fixCalendarProperty(resultBuilder, schema, info, schema.getCreationDate(), info.getCreationDate(), "CreateDate");
            MetadataFixerImpl.fixCalendarProperty(resultBuilder, schema, info, schema.getModificationDate(), info.getModificationDate(), "ModifyDate");
        }
    }

    private static void fixProperty(MetadataFixerResultImpl.Builder resultBuilder, BasicSchema schema, InfoDictionary info, String metaValue, String infoValue, String attribute) {
        if (infoValue != null) {
            String key = attributes.get(attribute);
            if (metaValue == null) {
                MetadataFixerImpl.doSaveAction(schema, attribute, infoValue);
                resultBuilder.addFix("Added '" + key + "' to metadata from info dictionary");
            } else if (!metaValue.equals(infoValue)) {
                MetadataFixerImpl.doSaveAction(info, attribute, metaValue);
                resultBuilder.addFix("Added '" + attribute + "' to info dictionary from metadata");
            }
        }
    }

    private static void fixCalendarProperty(MetadataFixerResultImpl.Builder resultBuilder, BasicSchema schema, InfoDictionary info, String metaValue, String infoValue, String attribute) {
        if (infoValue != null) {
            String key = attributes.get(attribute);
            String utcInfoValue = DateConverter.toUTCString(infoValue);
            if (metaValue == null) {
                MetadataFixerImpl.doSaveAction(schema, attribute, infoValue);
                resultBuilder.addFix("Added '" + key + "' to metadata from info dictionary");
            } else if (!metaValue.equals(utcInfoValue) || !infoValue.matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])")) {
                MetadataFixerImpl.doSaveAction(info, attribute, metaValue);
                resultBuilder.addFix("Added '" + attribute + "' to info dictionary from metadata");
            }
        }
    }

    private static void doSaveAction(BasicSchema schema, String attribute, String value) {
        switch (attribute) {
            case "title": {
                ((DublinCore)schema).setTitle(value);
                break;
            }
            case "description": {
                ((DublinCore)schema).setSubject(value);
                break;
            }
            case "creator": {
                ((DublinCore)schema).setAuthor(value);
                break;
            }
            case "Producer": {
                ((AdobePDF)schema).setProducer(value);
                break;
            }
            case "Keywords": {
                ((AdobePDF)schema).setKeywords(value);
                break;
            }
            case "CreatorTool": {
                ((XMPBasic)schema).setCreator(value);
                break;
            }
            case "CreateDate": {
                ((XMPBasic)schema).setCreationDate(value);
                break;
            }
            case "ModifyDate": {
                ((XMPBasic)schema).setModificationDate(value);
                break;
            }
            default: {
                return;
            }
        }
        schema.setNeedToBeUpdated(true);
    }

    private static void updateModificationDate(FixerConfig config, MetadataFixerResultImpl.Builder resultBuilder) {
        PDFDocument document = config.getDocument();
        InfoDictionary info = document.getInfoDictionary();
        XMPBasic schema = document.getMetadata().getXMPBasicSchema(info);
        if (document.isNeedToBeUpdated() && schema != null) {
            Calendar time = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (schema.getModificationDate() != null) {
                MetadataFixerImpl.doSaveAction(schema, "ModifyDate", DateConverter.toUTCString(time));
                resultBuilder.addFix("Set new modification date to metadata");
            }
            if (info != null && info.getModificationDate() != null) {
                MetadataFixerImpl.doSaveAction(info, "ModifyDate", DateConverter.toPDFFormat(time));
                resultBuilder.addFix("Set new modification date to info dictionary");
            }
        }
    }

    static {
        attributes.put("title", "Title");
        attributes.put("description", "Subject");
        attributes.put("creator", "Author");
        attributes.put("Producer", "Producer");
        attributes.put("Keywords", "Keywords");
        attributes.put("CreatorTool", "Creator");
        attributes.put("CreateDate", "CreationDate");
        attributes.put("ModifyDate", "ModDate");
    }
}

