/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.core.ModelParsingException;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.containers.StaticContainers;
import org.verapdf.model.impl.pb.cos.PBCosDocument;
import org.verapdf.pdfa.ValidationModelParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public final class ModelParser
implements ValidationModelParser,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(ModelParser.class);
    private static final PDFAFlavour DEFAULT_FLAVOUR = PDFAFlavour.PDFA_1_B;
    private PDDocument document;
    private final PDFAFlavour flavour;

    private ModelParser(InputStream docStream, PDFAFlavour flavour) throws IOException {
        this.document = PDDocument.load(docStream, false, true);
        this.flavour = flavour == PDFAFlavour.AUTO ? ModelParser.obtainFlavour(this.document) : flavour;
    }

    public static ModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws ModelParsingException {
        try {
            ModelParser.cleanUp();
            return new ModelParser(toLoad, flavour == PDFAFlavour.NO_FLAVOUR || flavour == null ? DEFAULT_FLAVOUR : flavour);
        }
        catch (IOException excep) {
            throw new ModelParsingException("Couldn't parse stream", excep);
        }
    }

    private static PDFAFlavour obtainFlavour(PDDocument document) {
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        if (documentCatalog == null) {
            return DEFAULT_FLAVOUR;
        }
        PDMetadata metadata = documentCatalog.getMetadata();
        if (metadata == null) {
            return DEFAULT_FLAVOUR;
        }
        try {
            InputStream is = metadata.exportXMPMetadata();
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse(is);
            Integer identificationPart = veraPDFMeta.getIdentificationPart();
            String identificationConformance = veraPDFMeta.getIdentificationConformance();
            PDFAFlavour pdfaFlavour = PDFAFlavour.byFlavourId(identificationPart + identificationConformance);
            return pdfaFlavour == PDFAFlavour.NO_FLAVOUR ? DEFAULT_FLAVOUR : pdfaFlavour;
        }
        catch (XMPException | IOException e) {
            LOGGER.error(e);
            return DEFAULT_FLAVOUR;
        }
    }

    private static void cleanUp() {
        StaticContainers.clearAllContainers();
    }

    public PDDocument getPDDocument() throws IOException {
        return this.document;
    }

    @Override
    public Object getRoot() {
        return new PBCosDocument(this.document, this.flavour);
    }

    @Override
    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    @Override
    public void close() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Problems with document close.", e);
        }
    }
}

