/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosFilter;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.cos.PBCosFilter;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosStream
extends PBCosDict
implements CosStream {
    private static final Logger logger = Logger.getLogger(PBCosStream.class);
    public static final String FILTERS = "filters";
    public static final String COS_STREAM_TYPE = "CosStream";
    public static final String F_DECODE_PARMS = "FDecodeParms";
    private final Long length;
    private final String fileSpec;
    private final String fFilter;
    private final String fDecodeParams;
    private final boolean streamKeywordCRLFCompliant;
    private final boolean endstreamKeywordEOLCompliant;
    private final boolean isLengthCorrect;

    public PBCosStream(COSStream stream, PDDocument document, PDFAFlavour flavour) {
        super(stream, COS_STREAM_TYPE, document, flavour);
        this.length = PBCosStream.parseLength(stream);
        this.fileSpec = stream.getItem("F") != null ? stream.getItem("F").toString() : null;
        this.fFilter = PBCosStream.parseFilters(stream.getDictionaryObject(COSName.F_FILTER));
        this.fDecodeParams = stream.getItem(F_DECODE_PARMS) != null ? stream.getItem(F_DECODE_PARMS).toString() : null;
        this.streamKeywordCRLFCompliant = stream.isStreamKeywordCRLFCompliant();
        this.endstreamKeywordEOLCompliant = stream.isEndstreamKeywordEOLCompliant();
        this.isLengthCorrect = this.length != null && this.length.equals(stream.getOriginLength());
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public String getF() {
        return this.fileSpec;
    }

    @Override
    public String getFFilter() {
        return this.fFilter;
    }

    @Override
    public String getFDecodeParms() {
        return this.fDecodeParams;
    }

    @Override
    public Boolean getstreamKeywordCRLFCompliant() {
        return this.streamKeywordCRLFCompliant;
    }

    @Override
    public Boolean getendstreamKeywordEOLCompliant() {
        return this.endstreamKeywordEOLCompliant;
    }

    @Override
    public Boolean getisLengthCorrect() {
        return this.isLengthCorrect;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "filters": {
                return this.getFilters();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosFilter> getFilters() {
        COSBase filters = ((COSStream)this.baseObject).getFilters();
        if (filters == null) {
            return Collections.emptyList();
        }
        ArrayList<CosFilter> result = new ArrayList<CosFilter>();
        COSBase decodeParms = ((COSStream)this.baseObject).getDictionaryObject(COSName.DECODE_PARMS);
        if (filters instanceof COSName) {
            if (decodeParms instanceof COSArray) {
                decodeParms = ((COSArray)decodeParms).get(0);
            }
            result.add(PBCosStream.createFilter((COSName)filters, decodeParms));
        } else if (filters instanceof COSArray) {
            for (int i = 0; i < ((COSArray)filters).size(); ++i) {
                COSBase filter = ((COSArray)filters).get(i);
                if (filter instanceof COSName) {
                    if (decodeParms == null) {
                        result.add(PBCosStream.createFilter((COSName)filter, null));
                        continue;
                    }
                    if (decodeParms instanceof COSArray && ((COSArray)decodeParms).size() < i) {
                        decodeParms = ((COSArray)decodeParms).get(i);
                        result.add(PBCosStream.createFilter((COSName)filter, decodeParms));
                        continue;
                    }
                    logger.warn("Invalid decodeParms type. Ignoring decodeParms.");
                    continue;
                }
                logger.warn("Invalid value type in filters array. Skipping the filter");
            }
        }
        return result;
    }

    private static CosFilter createFilter(COSName filter, COSBase decodeParms) {
        if (decodeParms == null) {
            return new PBCosFilter(filter, null);
        }
        if (decodeParms instanceof COSDictionary) {
            return new PBCosFilter(filter, (COSDictionary)decodeParms);
        }
        logger.warn("Invalid decodeParms type. Ignoring decodeParms.");
        return new PBCosFilter(filter, null);
    }

    private static Long parseLength(COSStream stream) {
        COSBase number = stream.getDictionaryObject(COSName.LENGTH);
        return number instanceof COSNumber ? Long.valueOf(((COSNumber)number).longValue()) : null;
    }

    private static String parseFilters(COSBase base) {
        StringBuilder filters = new StringBuilder();
        if (base == null) {
            return null;
        }
        if (base instanceof COSName) {
            return ((COSName)base).getName();
        }
        if (base instanceof COSArray) {
            for (COSBase filter : (COSArray)base) {
                if (filter instanceof COSName) {
                    filters.append(((COSName)filter).getName()).append(" ");
                    continue;
                }
                logger.error("Incorrect type for stream filter " + filter.getClass().getName());
            }
        } else {
            logger.error("Incorrect type for stream filter " + base.getClass().getName());
            return null;
        }
        return filters.substring(0, filters.length() - 1);
    }
}

