/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSString;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.impl.pb.external.PBoxExternal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;

public class PBoxPKCSDataObject
extends PBoxExternal
implements PKCSDataObject {
    private static final Logger LOGGER = Logger.getLogger(PBoxPKCSDataObject.class);
    public static final String PKCS_DATA_OBJECT_TYPE = "PKCSDataObject";
    protected PKCS7 pkcs7;

    public PBoxPKCSDataObject(COSString pkcsData) {
        super(PKCS_DATA_OBJECT_TYPE);
        try {
            this.pkcs7 = new PKCS7(pkcsData.getBytes());
        }
        catch (ParsingException e) {
            LOGGER.error("Passed PKCS7 object can't be read", e);
            this.pkcs7 = this.getEmptyPKCS7();
        }
    }

    @Override
    public Long getSignerInfoCount() {
        return new Integer(this.pkcs7.getSignerInfos().length).longValue();
    }

    @Override
    public Boolean getsigningCertificatePresent() {
        X509Certificate[] certificates = this.pkcs7.getCertificates();
        if (certificates.length == 0) {
            return false;
        }
        for (X509Certificate cert : certificates) {
            if (cert != null) continue;
            return false;
        }
        return true;
    }

    private PKCS7 getEmptyPKCS7() {
        return new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), new X509Certificate[0], new SignerInfo[0]);
    }
}

