/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDHalftone;

public class PBoxPDHalftone
extends PBoxPDObject
implements PDHalftone {
    public static final String HALFTONE_TYPE = "PDHalftone";
    private final String halftoneName;
    private final Long halftoneType;

    public PBoxPDHalftone(COSDictionary dict) {
        super(dict, HALFTONE_TYPE);
        this.halftoneName = this.getHalftoneName(dict);
        this.halftoneType = this.getHalftoneType(dict);
    }

    public PBoxPDHalftone(COSName name) {
        super(name, HALFTONE_TYPE);
        this.halftoneName = name.getName();
        this.halftoneType = null;
    }

    private Long getHalftoneType(COSDictionary dict) {
        COSBase type = dict.getDictionaryObject(COSName.getPDFName("HalftoneType"));
        return !(type instanceof COSNumber) ? null : Long.valueOf(((COSNumber)type).longValue());
    }

    private String getHalftoneName(COSDictionary dict) {
        COSBase name = dict.getDictionaryObject(COSName.getPDFName("HalftoneName"));
        if (name instanceof COSName) {
            return ((COSName)name).getName();
        }
        if (name instanceof COSString) {
            return ((COSString)name).getString();
        }
        if (name != null) {
            return name.toString();
        }
        return null;
    }

    @Override
    public Long getHalftoneType() {
        return this.halftoneType;
    }

    @Override
    public String getHalftoneName() {
        return this.halftoneName;
    }
}

