/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.pdlayer.PDStructTreeRoot;
import org.verapdf.model.tools.TaggedPDFHelper;
import org.verapdf.model.tools.TaggedPDFRoleMapHelper;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDStructTreeRoot
extends PBoxPDObject
implements PDStructTreeRoot {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDStructTreeRoot.class);
    public static final String STRUCT_TREE_ROOT_TYPE = "PDStructTreeRoot";
    public static final String CHILDREN = "K";
    private List<PDStructElem> children = null;
    private PDFAFlavour flavour;

    public PBoxPDStructTreeRoot(PDStructureTreeRoot treeRoot, PDFAFlavour flavour) {
        super(treeRoot, STRUCT_TREE_ROOT_TYPE);
        this.flavour = flavour;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (CHILDREN.equals(link)) {
            return this.getChildren();
        }
        return super.getLinkedObjects(link);
    }

    private List<PDStructElem> getChildren() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        return this.children;
    }

    private List<PDStructElem> parseChildren() {
        COSDictionary parent = ((PDStructureTreeRoot)this.simplePDObject).getCOSObject();
        return TaggedPDFHelper.getChildren(parent, new TaggedPDFRoleMapHelper(this.getRoleMap(), this.flavour), LOGGER);
    }

    private Map<String, String> getRoleMap() {
        Map<String, java.lang.Object> tempMap = ((PDStructureTreeRoot)this.simplePDObject).getRoleMap();
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (Map.Entry<String, java.lang.Object> entry : tempMap.entrySet()) {
            resMap.put(entry.getKey(), entry.getValue().toString());
        }
        return resMap;
    }

    @Override
    public String gettopLevelFirstElementStandartType() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        if (!this.children.isEmpty()) {
            return this.children.get(0).getstandartType();
        }
        return null;
    }
}

