/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.visitor.cos.pb;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.impl.pb.cos.PBCosArray;
import org.verapdf.model.impl.pb.cos.PBCosBool;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.cos.PBCosDocument;
import org.verapdf.model.impl.pb.cos.PBCosFileSpecification;
import org.verapdf.model.impl.pb.cos.PBCosIndirect;
import org.verapdf.model.impl.pb.cos.PBCosInteger;
import org.verapdf.model.impl.pb.cos.PBCosName;
import org.verapdf.model.impl.pb.cos.PBCosNull;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.cos.PBCosString;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public final class PBCosVisitor
implements ICOSVisitor {
    private final PDDocument document;
    private final PDFAFlavour flavour;

    private PBCosVisitor(PDDocument document, PDFAFlavour flavour) {
        this.document = document;
        this.flavour = flavour;
    }

    public static PBCosVisitor getInstance(PDDocument document, PDFAFlavour flavour) {
        return new PBCosVisitor(document, flavour);
    }

    @Override
    public Object visitFromArray(COSArray obj) throws IOException {
        return new PBCosArray(obj, this.document, this.flavour);
    }

    @Override
    public Object visitFromBoolean(COSBoolean obj) throws IOException {
        return PBCosBool.valueOf(obj);
    }

    @Override
    public Object visitFromDictionary(COSDictionary obj) throws IOException {
        COSName type = obj.getCOSName(COSName.TYPE);
        boolean isFileSpec = type != null && COSName.FILESPEC.equals(type);
        return isFileSpec ? new PBCosFileSpecification(obj, this.document, this.flavour) : new PBCosDict(obj, this.document, this.flavour);
    }

    @Override
    public Object visitFromDocument(COSDocument obj) throws IOException {
        return new PBCosDocument(obj, this.flavour);
    }

    @Override
    public Object visitFromFloat(COSFloat obj) throws IOException {
        return new PBCosReal(obj);
    }

    @Override
    public Object visitFromInt(COSInteger obj) throws IOException {
        return new PBCosInteger(obj);
    }

    @Override
    public Object visitFromName(COSName obj) throws IOException {
        return new PBCosName(obj);
    }

    @Override
    public Object visitFromNull(COSNull obj) throws IOException {
        return PBCosNull.getInstance();
    }

    @Override
    public Object visitFromStream(COSStream obj) throws IOException {
        return new PBCosStream(obj, this.document, this.flavour);
    }

    @Override
    public Object visitFromString(COSString obj) throws IOException {
        return new PBCosString(obj);
    }

    public static Object visitFromObject(COSObject obj, PDDocument document, PDFAFlavour flavour) {
        return new PBCosIndirect(obj, document, flavour);
    }
}

