/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.verapdf.pdfa.results.MetadataFixerResult;

public class MetadataFixerResultImpl
implements MetadataFixerResult {
    private final MetadataFixerResult.RepairStatus status;
    private final List<String> appliedFixes;

    private MetadataFixerResultImpl() {
        this(MetadataFixerResult.RepairStatus.NO_ACTION, new ArrayList<String>());
    }

    private MetadataFixerResultImpl(MetadataFixerResult.RepairStatus status, List<String> fixes) {
        this.status = status;
        this.appliedFixes = new ArrayList<String>(fixes);
    }

    @Override
    public MetadataFixerResult.RepairStatus getRepairStatus() {
        return this.status;
    }

    @Override
    public List<String> getAppliedFixes() {
        return Collections.unmodifiableList(this.appliedFixes);
    }

    @Override
    public Iterator<String> iterator() {
        return this.appliedFixes.iterator();
    }

    public static MetadataFixerResult fromValues(MetadataFixerResult.RepairStatus status, List<String> fixes) {
        return new MetadataFixerResultImpl(status, fixes);
    }

    public static class Builder {
        private MetadataFixerResult.RepairStatus status = MetadataFixerResult.RepairStatus.NO_ACTION;
        private final List<String> fixes = new ArrayList<String>();

        public Builder status(MetadataFixerResult.RepairStatus status) {
            this.status = status;
            return this;
        }

        public MetadataFixerResult.RepairStatus getStatus() {
            return this.status;
        }

        public Builder addFix(String fix) {
            this.fixes.add(fix);
            return this;
        }

        public MetadataFixerResult build() {
            return MetadataFixerResultImpl.fromValues(this.status, this.fixes);
        }
    }
}

