/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;

@XmlRootElement(name="validationResult")
final class ValidationResultImpl
implements ValidationResult {
    private static final ValidationResultImpl DEFAULT = new ValidationResultImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlAttribute
    private final int totalAssertions;
    @XmlElementWrapper
    @XmlElement(name="assertion")
    private final Set<TestAssertion> assertions;
    @XmlAttribute
    private final boolean isCompliant;

    private ValidationResultImpl() {
        this(PDFAFlavour.NO_FLAVOUR, Collections.emptySet(), false);
    }

    private ValidationResultImpl(PDFAFlavour flavour, Set<TestAssertion> assertions, boolean isCompliant) {
        this(flavour, assertions, isCompliant, assertions.size());
    }

    private ValidationResultImpl(PDFAFlavour flavour, Set<TestAssertion> assertions, boolean isCompliant, int totalAssertions) {
        this.flavour = flavour;
        this.assertions = new HashSet<TestAssertion>(assertions);
        this.isCompliant = isCompliant;
        this.totalAssertions = totalAssertions;
    }

    @Override
    public boolean isCompliant() {
        return this.isCompliant;
    }

    @Override
    public PDFAFlavour getPDFAFlavour() {
        return this.flavour;
    }

    @Override
    public int getTotalAssertions() {
        return this.totalAssertions;
    }

    @Override
    public Set<TestAssertion> getTestAssertions() {
        return Collections.unmodifiableSet(this.assertions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assertions == null ? 0 : this.assertions.hashCode());
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + (this.isCompliant ? 1231 : 1237);
        result = 31 * result + this.totalAssertions;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        if (this.assertions == null) {
            if (other.getTestAssertions() != null) {
                return false;
            }
        } else {
            if (other.getTestAssertions() == null) {
                return false;
            }
            if (!this.assertions.equals(other.getTestAssertions())) {
                return false;
            }
        }
        if (this.flavour != other.getPDFAFlavour()) {
            return false;
        }
        if (this.isCompliant != other.isCompliant()) {
            return false;
        }
        return this.totalAssertions == other.getTotalAssertions();
    }

    public String toString() {
        return "ValidationResult [flavour=" + (Object)((Object)this.flavour) + ", totalAssertions=" + this.totalAssertions + ", assertions=" + this.assertions + ", isCompliant=" + this.isCompliant + "]";
    }

    static ValidationResultImpl defaultInstance() {
        return DEFAULT;
    }

    static ValidationResultImpl fromValues(PDFAFlavour flavour, Set<TestAssertion> assertions, boolean isCompliant, int totalChecks) {
        return new ValidationResultImpl(flavour, assertions, isCompliant, totalChecks);
    }

    static ValidationResultImpl fromValidationResult(ValidationResult toConvert) {
        return ValidationResultImpl.fromValues(toConvert.getPDFAFlavour(), toConvert.getTestAssertions(), toConvert.isCompliant(), toConvert.getTotalAssertions());
    }

    static ValidationResultImpl stripPassedTests(ValidationResult toStrip) {
        return ValidationResultImpl.fromValues(toStrip.getPDFAFlavour(), ValidationResultImpl.stripPassedTests(toStrip.getTestAssertions()), toStrip.isCompliant(), toStrip.getTotalAssertions());
    }

    static String toXml(ValidationResult toConvert, Boolean prettyXml) throws JAXBException, IOException {
        String retVal = "";
        try (StringWriter writer = new StringWriter();){
            ValidationResultImpl.toXml(toConvert, writer, prettyXml);
            String string = retVal = writer.toString();
            return string;
        }
    }

    static void toXml(ValidationResult toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ValidationResultImpl.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    static ValidationResultImpl fromXml(InputStream toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = ValidationResultImpl.getUnmarshaller();
        return (ValidationResultImpl)stringUnmarshaller.unmarshal(toConvert);
    }

    static void toXml(ValidationResult toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ValidationResultImpl.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, writer);
    }

    static ValidationResultImpl fromXml(Reader toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = ValidationResultImpl.getUnmarshaller();
        return (ValidationResultImpl)stringUnmarshaller.unmarshal(toConvert);
    }

    static ValidationResultImpl fromXml(String toConvert) throws JAXBException {
        try (StringReader reader = new StringReader(toConvert);){
            ValidationResultImpl validationResultImpl = ValidationResultImpl.fromXml(reader);
            return validationResultImpl;
        }
    }

    static String getSchema() throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationResultImpl.class});
        StringWriter writer = new StringWriter();
        context.generateSchema((SchemaOutputResolver)new WriterSchemaOutputResolver(writer));
        return writer.toString();
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationResultImpl.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationResultImpl.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }

    static Set<TestAssertion> stripPassedTests(Set<TestAssertion> toStrip) {
        HashSet<TestAssertion> strippedSet = new HashSet<TestAssertion>();
        for (TestAssertion test : toStrip) {
            if (test.getStatus() == TestAssertion.Status.PASSED) continue;
            strippedSet.add(test);
        }
        return strippedSet;
    }

    private static class WriterSchemaOutputResolver
    extends SchemaOutputResolver {
        private final Writer out;

        public WriterSchemaOutputResolver(Writer out) {
            this.out = out;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            StreamResult result = new StreamResult(this.out);
            result.setSystemId("no-id");
            return result;
        }
    }

    static class Adapter
    extends XmlAdapter<ValidationResultImpl, ValidationResult> {
        Adapter() {
        }

        public ValidationResult unmarshal(ValidationResultImpl validationResultImpl) {
            return validationResultImpl;
        }

        public ValidationResultImpl marshal(ValidationResult validationResult) {
            return (ValidationResultImpl)validationResult;
        }
    }
}

