/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.ProfileDetails;
import org.verapdf.pdfa.validation.ProfileDetailsImpl;
import org.verapdf.pdfa.validation.Rule;
import org.verapdf.pdfa.validation.RuleId;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.verapdf.pdfa.validation.Variable;

@XmlRootElement(namespace="http://www.verapdf.org/ValidationProfile", name="profile")
final class ValidationProfileImpl
implements ValidationProfile {
    private Map<String, Set<Rule>> objectRuleMap;
    private Map<String, Set<Variable>> objectVariableMap;
    private Map<RuleId, Rule> ruleLookup = new HashMap<RuleId, Rule>();
    private static final ValidationProfileImpl DEFAULT = new ValidationProfileImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlElement
    private final ProfileDetails details;
    @XmlElement
    private final String hash;
    @XmlElementWrapper
    @XmlElement(name="rule")
    private final Set<Rule> rules;
    @XmlElementWrapper
    @XmlElement(name="variable")
    private final Set<Variable> variables;

    private ValidationProfileImpl() {
        this(PDFAFlavour.NO_FLAVOUR, (ProfileDetails)ProfileDetailsImpl.defaultInstance(), "hash", Collections.emptySet(), Collections.emptySet());
    }

    private ValidationProfileImpl(PDFAFlavour flavour, ProfileDetails details, String hash, Set<Rule> rules, Set<Variable> variables) {
        this.flavour = flavour;
        this.details = details;
        this.hash = hash;
        this.rules = new HashSet<Rule>(rules);
        this.variables = new HashSet<Variable>(variables);
    }

    private ValidationProfileImpl(PDFAFlavour flavour, ProfileDetails details, String hash, SortedSet<Rule> rules, Set<Variable> variables) {
        this.flavour = flavour;
        this.details = details;
        this.hash = hash;
        this.rules = rules;
        this.variables = new HashSet<Variable>(variables);
    }

    @Override
    public PDFAFlavour getPDFAFlavour() {
        return this.flavour;
    }

    @Override
    public ProfileDetails getDetails() {
        return this.details;
    }

    @Override
    public String getHexSha1Digest() {
        return this.hash;
    }

    @Override
    public Set<Rule> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    @Override
    public Set<Variable> getVariables() {
        return Collections.unmodifiableSet(this.variables);
    }

    @Override
    public Set<Rule> getRulesByObject(String objectName) {
        Set<Rule> objRules;
        if (this.objectRuleMap == null) {
            this.objectRuleMap = this.createObjectRuleMap(this.rules);
        }
        return (objRules = this.objectRuleMap.get(objectName)) == null ? Collections.emptySet() : Collections.unmodifiableSet(objRules);
    }

    @Override
    public Set<Variable> getVariablesByObject(String objectName) {
        Set<Variable> objRules;
        if (this.objectVariableMap == null) {
            this.objectVariableMap = ValidationProfileImpl.createObjectVariableMap(this.variables);
        }
        return (objRules = this.objectVariableMap.get(objectName)) == null ? Collections.emptySet() : Collections.unmodifiableSet(objRules);
    }

    @Override
    public Rule getRuleByRuleId(RuleId id) {
        if (this.ruleLookup.isEmpty()) {
            this.objectRuleMap = this.createObjectRuleMap(this.rules);
        }
        return this.ruleLookup.get(id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        result = 31 * result + (this.rules == null ? 0 : this.rules.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationProfile)) {
            return false;
        }
        ValidationProfile other = (ValidationProfile)obj;
        if (this.flavour != other.getPDFAFlavour()) {
            return false;
        }
        if (this.hash == null ? other.getHexSha1Digest() != null : !this.hash.equals(other.getHexSha1Digest())) {
            return false;
        }
        if (this.details == null ? other.getDetails() != null : !this.details.equals(other.getDetails())) {
            return false;
        }
        if (this.rules == null ? other.getRules() != null : !this.rules.equals(other.getRules())) {
            return false;
        }
        return !(this.variables == null ? other.getVariables() != null : !this.variables.equals(other.getVariables()));
    }

    public String toString() {
        return "ValidationProfile [flavour=" + (Object)((Object)this.flavour) + ", details=" + this.details + ", hash=" + this.hash + ", rules=" + this.rules + ", variables=" + this.variables + "]";
    }

    static ValidationProfileImpl defaultInstance() {
        return DEFAULT;
    }

    static ValidationProfileImpl fromValues(PDFAFlavour flavour, ProfileDetails details, String hash, Set<Rule> rules, Set<Variable> variables) {
        return new ValidationProfileImpl(flavour, details, hash, rules, variables);
    }

    static ValidationProfileImpl fromSortedValues(PDFAFlavour flavour, ProfileDetails details, String hash, SortedSet<Rule> rules, Set<Variable> variables) {
        return new ValidationProfileImpl(flavour, details, hash, rules, variables);
    }

    static ValidationProfileImpl fromValidationProfile(ValidationProfile toConvert) {
        return ValidationProfileImpl.fromValues(toConvert.getPDFAFlavour(), toConvert.getDetails(), toConvert.getHexSha1Digest(), toConvert.getRules(), toConvert.getVariables());
    }

    static String toXml(ValidationProfile toConvert, Boolean prettyXml) throws JAXBException, IOException {
        String retVal = "";
        try (StringWriter writer = new StringWriter();){
            ValidationProfileImpl.toXml(toConvert, writer, prettyXml);
            String string = retVal = writer.toString();
            return string;
        }
    }

    static ValidationProfileImpl fromXml(String toConvert) throws JAXBException {
        try (StringReader reader = new StringReader(toConvert);){
            ValidationProfileImpl validationProfileImpl = ValidationProfileImpl.fromXml(reader);
            return validationProfileImpl;
        }
    }

    static void toXml(ValidationProfile toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ValidationProfileImpl.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    static ValidationProfileImpl fromXml(InputStream toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = ValidationProfileImpl.getUnmarshaller();
        return (ValidationProfileImpl)stringUnmarshaller.unmarshal(toConvert);
    }

    static void toXml(ValidationProfile toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ValidationProfileImpl.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, writer);
    }

    static ValidationProfileImpl fromXml(Reader toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = ValidationProfileImpl.getUnmarshaller();
        return (ValidationProfileImpl)stringUnmarshaller.unmarshal(toConvert);
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationProfileImpl.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationProfileImpl.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }

    private Map<String, Set<Rule>> createObjectRuleMap(Set<Rule> rules) {
        this.ruleLookup.clear();
        HashMap<String, Set<Rule>> rulesByObject = new HashMap<String, Set<Rule>>();
        for (Rule rule : rules) {
            this.ruleLookup.put(rule.getRuleId(), rule);
            if (!rulesByObject.containsKey(rule.getObject())) {
                rulesByObject.put(rule.getObject(), new HashSet());
            }
            ((Set)rulesByObject.get(rule.getObject())).add(rule);
        }
        return rulesByObject;
    }

    private static Map<String, Set<Variable>> createObjectVariableMap(Set<Variable> variables) {
        HashMap<String, Set<Variable>> variablesByObject = new HashMap<String, Set<Variable>>();
        for (Variable rule : variables) {
            if (!variablesByObject.containsKey(rule.getObject())) {
                variablesByObject.put(rule.getObject(), new HashSet());
            }
            ((Set)variablesByObject.get(rule.getObject())).add(rule);
        }
        return variablesByObject;
    }

    static String getSchema() throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationProfileImpl.class});
        StringWriter writer = new StringWriter();
        context.generateSchema((SchemaOutputResolver)new WriterSchemaOutputResolver(writer));
        return writer.toString();
    }

    private static class WriterSchemaOutputResolver
    extends SchemaOutputResolver {
        private final Writer out;

        public WriterSchemaOutputResolver(Writer out) {
            this.out = out;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            StreamResult result = new StreamResult(this.out);
            result.setSystemId("no-id");
            return result;
        }
    }

    static class Adapter
    extends XmlAdapter<ValidationProfileImpl, ValidationProfile> {
        Adapter() {
        }

        public ValidationProfileImpl unmarshal(ValidationProfileImpl profileImpl) {
            return profileImpl;
        }

        public ValidationProfileImpl marshal(ValidationProfile profile) {
            return (ValidationProfileImpl)profile;
        }
    }
}

