/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import org.verapdf.features.pb.PBFeatureParser;
import org.verapdf.features.tools.FeaturesCollection;
import org.verapdf.metadata.fixer.impl.MetadataFixerImpl;
import org.verapdf.metadata.fixer.impl.pb.FixerConfigImpl;
import org.verapdf.metadata.fixer.utils.FileGenerator;
import org.verapdf.metadata.fixer.utils.FixerConfig;
import org.verapdf.model.ModelParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.pdfa.validation.RuleId;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.verapdf.pdfa.validators.Validators;
import org.verapdf.processor.ProcessingResult;
import org.verapdf.processor.Processor;
import org.verapdf.processor.config.Config;
import org.verapdf.processor.config.FormatOption;
import org.verapdf.processor.config.ProcessingType;
import org.verapdf.report.CliReport;
import org.verapdf.report.FeaturesReport;
import org.verapdf.report.HTMLReport;
import org.verapdf.report.ItemDetails;
import org.verapdf.report.MachineReadableReport;

public class ProcessorImpl
implements Processor {
    private static final Logger LOGGER = Logger.getLogger(ProcessorImpl.class);
    private ProcessingResult processingResult;

    @Override
    public ProcessingResult validate(InputStream pdfFileStream, ItemDetails fileDetails, Config config, OutputStream reportOutputStream) {
        long startTimeOfProcessing = System.currentTimeMillis();
        this.checkArguments(pdfFileStream, fileDetails, config, reportOutputStream);
        ValidationResult validationResult = null;
        MetadataFixerResult fixerResult = null;
        FeaturesCollection featuresCollection = null;
        this.processingResult = new ProcessingResult(config);
        ValidationProfile validationProfile = this.profileFromConfig(config);
        PDFAFlavour currentFlavour = validationProfile == null ? config.getFlavour() : validationProfile.getPDFAFlavour();
        ProcessingType processingType = config.getProcessingType();
        try (ModelParser parser = ModelParser.createModelWithFlavour(pdfFileStream, currentFlavour);){
            if (processingType.isValidating()) {
                if (validationProfile == null) {
                    validationProfile = this.profileFromFlavour(parser.getFlavour());
                }
                validationResult = this.startValidation(validationProfile, parser, config, fileDetails);
                if (config.isFixMetadata() && validationResult != null) {
                    fixerResult = this.fixMetadata(validationResult, parser, fileDetails.getName(), config);
                }
            }
            if (processingType.isFeatures()) {
                featuresCollection = this.extractFeatures(parser, config);
            }
        }
        catch (ModelParsingException e) {
            if (e.getCause() instanceof InvalidPasswordException) {
                LOGGER.error("Error: " + fileDetails.getName() + " is an encrypted PDF file.", e);
                this.setUnsuccessfulProcessing();
                this.processingResult.addErrorMessage("Error in reading PDF file: " + e.getCause().getMessage());
                return this.processingResult;
            }
            LOGGER.error("Error: " + fileDetails.getName() + " is not a PDF format file.", e);
            this.setUnsuccessfulProcessing();
            this.processingResult.addErrorMessage("Error in reading PDF file: " + e.getMessage());
            return this.processingResult;
        }
        long endTimeOfProcessing = System.currentTimeMillis();
        this.writeReport(config, validationResult, fileDetails, reportOutputStream, validationProfile, fixerResult, featuresCollection, endTimeOfProcessing - startTimeOfProcessing);
        return this.processingResult;
    }

    private void checkArguments(InputStream pdfFileStream, ItemDetails fileDetails, Config config, OutputStream reportOutputStream) {
        if (pdfFileStream == null) {
            throw new IllegalArgumentException("PDF file stream cannot be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        if (reportOutputStream == null) {
            throw new IllegalArgumentException("Output stream for report cannot be null");
        }
        if (config.getProcessingType().isValidating() && config.getFlavour() == PDFAFlavour.NO_FLAVOUR && config.getValidationProfile().toString().equals("")) {
            throw new IllegalArgumentException("Validation cannot be started with no chosen validation profile");
        }
        if (fileDetails == null) {
            throw new IllegalArgumentException("Item details cannot be null");
        }
    }

    private static boolean logPassed(Config config) {
        return config.getReportType() != FormatOption.XML || config.isShowPassedRules();
    }

    ValidationProfile profileFromConfig(Config config) {
        try {
            if (config.getValidationProfile().toString().equals("")) {
                return null;
            }
            ValidationProfile profile = ProcessorImpl.profileFromFile(config.getValidationProfile().toFile());
            return profile;
        }
        catch (JAXBException e) {
            LOGGER.error("Error in parsing profile XML", e);
            this.processingResult.addErrorMessage("Error in parsing profile from XML: " + e.getMessage());
            this.setUnsuccessfulValidation();
            this.setUnsuccessfulMetadataFixing();
            return Profiles.defaultProfile();
        }
        catch (IOException e) {
            LOGGER.error("Error in reading profile from disc", e);
            this.processingResult.addErrorMessage("Error in reading profile from disc: " + e.getMessage());
            this.setUnsuccessfulValidation();
            this.setUnsuccessfulMetadataFixing();
            return Profiles.defaultProfile();
        }
    }

    private static ValidationProfile profileFromFile(File profileFile) throws JAXBException, IOException {
        ValidationProfile profile = Profiles.defaultProfile();
        FileInputStream is = new FileInputStream(profileFile);
        profile = Profiles.profileFromXml(is);
        ((InputStream)is).close();
        if ("sha-1 hash code".equals(profile.getHexSha1Digest())) {
            return Profiles.defaultProfile();
        }
        return profile;
    }

    private ValidationResult startValidation(ValidationProfile validationProfile, ModelParser parser, Config config, ItemDetails fileDetails) {
        PDFAValidator validator = Validators.createValidator(validationProfile, ProcessorImpl.logPassed(config), config.getMaxNumberOfFailedChecks());
        ValidationResult validationResult = this.validate(validator, parser);
        return validationResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetadataFixerResult fixMetadata(ValidationResult info, ModelParser parser, String fileName, Config config) {
        try {
            FixerConfig fixerConfig = FixerConfigImpl.getFixerConfig(parser.getPDDocument(), info);
            Path path = config.getFixMetadataFolder();
            File tempFile = File.createTempFile("fixedTempFile", ".pdf");
            tempFile.deleteOnExit();
            try (BufferedOutputStream tempOutput = new BufferedOutputStream(new FileOutputStream(tempFile));){
                MetadataFixerResult fixerResult = MetadataFixerImpl.fixMetadata(tempOutput, fixerConfig);
                MetadataFixerResult.RepairStatus repairStatus = fixerResult.getRepairStatus();
                if (repairStatus == MetadataFixerResult.RepairStatus.SUCCESS || repairStatus == MetadataFixerResult.RepairStatus.ID_REMOVED) {
                    boolean flag = true;
                    while (flag) {
                        File resFile = !path.toString().trim().isEmpty() ? FileGenerator.createOutputFile(path.toFile(), new File(fileName).getName(), config.getMetadataFixerPrefix()) : FileGenerator.createOutputFile(new File(fileName), config.getMetadataFixerPrefix());
                        Files.copy(tempFile.toPath(), resFile.toPath(), new CopyOption[0]);
                        flag = false;
                    }
                }
                MetadataFixerResult metadataFixerResult = fixerResult;
                return metadataFixerResult;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error in fixing metadata", e);
            this.setUnsuccessfulMetadataFixing();
            this.processingResult.addErrorMessage("Error in fixing metadata: " + e.getMessage());
            return null;
        }
    }

    private FeaturesCollection extractFeatures(ModelParser parser, Config config) {
        FeaturesCollection featuresCollection = null;
        try {
            String appHome = System.getProperty("app.home");
            Path pluginsPath = null;
            if (appHome != null) {
                pluginsPath = new File(appHome, "plugins").toPath();
            }
            featuresCollection = PBFeatureParser.getFeaturesCollection(parser.getPDDocument(), config.isPluginsEnabled(), pluginsPath);
        }
        catch (Exception e) {
            LOGGER.error("Error in extracting features", e);
            this.setUnsuccessfulFeatureExtracting();
            this.processingResult.addErrorMessage("Error in feature extraction: " + e.getMessage());
        }
        return featuresCollection;
    }

    private ValidationProfile profileFromFlavour(PDFAFlavour flavour) {
        ValidationProfile validationProfile = null;
        try {
            validationProfile = Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour);
        }
        catch (NoSuchElementException re) {
            LOGGER.warn(re);
        }
        return validationProfile;
    }

    private ValidationResult validate(PDFAValidator validator, ModelParser parser) {
        ValidationResult validationResult = null;
        try {
            validationResult = validator.validate(parser);
            if (!validationResult.isCompliant()) {
                this.processingResult.setValidationSummary(ProcessingResult.ValidationSummary.FILE_NOT_VALID);
            }
        }
        catch (ModelParsingException | ValidationException e) {
            LOGGER.error("Error in validation", e);
            this.setUnsuccessfulValidation();
            this.setUnsuccessfulMetadataFixing();
            this.processingResult.addErrorMessage("Error in validation: " + e.getMessage());
        }
        return validationResult;
    }

    private void writeReport(Config config, ValidationResult validationResult, ItemDetails fileDetails, OutputStream reportOutputStream, ValidationProfile validationProfile, MetadataFixerResult fixerResult, FeaturesCollection featuresCollection, long processingTime) {
        try {
            switch (config.getReportType()) {
                case TEXT: {
                    this.writeTextReport(validationResult, fileDetails, reportOutputStream, config);
                    break;
                }
                case MRR: 
                case HTML: {
                    this.writeMRR(fileDetails, validationProfile, validationResult, config, fixerResult, featuresCollection, processingTime, reportOutputStream);
                    break;
                }
                case XML: {
                    CliReport report = CliReport.fromValues(fileDetails, validationResult, FeaturesReport.fromValues(featuresCollection));
                    CliReport.toXml(report, reportOutputStream, Boolean.TRUE);
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong or unknown report type.");
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception raised while writing report to file", e);
            this.processingResult.setReportSummary(ProcessingResult.ReportSummary.ERROR_IN_REPORT);
            this.processingResult.addErrorMessage("Error in writing report to file: " + e.getMessage());
        }
        catch (JAXBException e) {
            LOGGER.error("Exception raised while converting report to XML file", e);
            this.processingResult.setReportSummary(ProcessingResult.ReportSummary.ERROR_IN_REPORT);
            this.processingResult.addErrorMessage("Error in generating XML report file: " + e.getMessage());
        }
        catch (TransformerException e) {
            LOGGER.error("Exception raised while converting MRR report into HTML", e);
            this.processingResult.setReportSummary(ProcessingResult.ReportSummary.ERROR_IN_REPORT);
            this.processingResult.addErrorMessage("Error in converting MRR report to HTML:" + e.getMessage());
        }
    }

    private void writeTextReport(ValidationResult validationResult, ItemDetails fileDetails, OutputStream reportOutputStream, Config config) throws IOException {
        if (validationResult != null) {
            String reportSummary = (validationResult.isCompliant() ? "PASS " : "FAIL ") + fileDetails.getName() + "\n";
            reportOutputStream.write(reportSummary.getBytes());
            if (config.isVerboseCli()) {
                HashSet<RuleId> ruleIds = new HashSet<RuleId>();
                for (TestAssertion assertion : validationResult.getTestAssertions()) {
                    if (assertion.getStatus() != TestAssertion.Status.FAILED) continue;
                    ruleIds.add(assertion.getRuleId());
                }
                for (RuleId id : ruleIds) {
                    String reportRuleSummary = id.getClause() + "-" + id.getTestNumber() + "\n";
                    reportOutputStream.write(reportRuleSummary.getBytes());
                }
            }
        }
    }

    private void writeMRR(ItemDetails fileDetails, ValidationProfile validationProfile, ValidationResult validationResult, Config config, MetadataFixerResult fixerResult, FeaturesCollection featuresCollection, long processingTime, OutputStream reportOutputStream) throws JAXBException, IOException, TransformerException {
        MachineReadableReport machineReadableReport = MachineReadableReport.fromValues(fileDetails, validationProfile, validationResult, config.isShowPassedRules(), config.getMaxNumberOfDisplayedFailedChecks(), fixerResult, featuresCollection, processingTime);
        if (config.getReportType() == FormatOption.MRR) {
            MachineReadableReport.toXml(machineReadableReport, reportOutputStream, Boolean.TRUE);
        } else {
            if (config.getReportType() == FormatOption.HTML) {
                File tmp = File.createTempFile("verpdf", "xml");
                tmp.deleteOnExit();
                try (FileOutputStream os = new FileOutputStream(tmp);){
                    MachineReadableReport.toXml(machineReadableReport, os, Boolean.FALSE);
                }
                var13_12 = null;
                try (FileInputStream is = new FileInputStream(tmp);){
                    HTMLReport.writeHTMLReport(is, reportOutputStream, config.getProfileWikiPath());
                }
                catch (Throwable throwable) {
                    var13_12 = throwable;
                    throw throwable;
                }
            }
            throw new IllegalStateException("This method should be used only for MRR or HTML reports");
        }
    }

    private void setUnsuccessfulValidation() {
        if (this.processingResult.getValidationSummary() != ProcessingResult.ValidationSummary.VALIDATION_DISABLED) {
            this.processingResult.setValidationSummary(ProcessingResult.ValidationSummary.ERROR_IN_VALIDATION);
        }
    }

    private void setUnsuccessfulMetadataFixing() {
        if (this.processingResult.getMetadataFixerSummary() != ProcessingResult.MetadataFixingSummary.FIXING_DISABLED) {
            this.processingResult.setMetadataFixerSummary(ProcessingResult.MetadataFixingSummary.ERROR_IN_FIXING);
        }
    }

    private void setUnsuccessfulFeatureExtracting() {
        if (this.processingResult.getFeaturesSummary() != ProcessingResult.FeaturesSummary.FEATURES_DISABLED) {
            this.processingResult.setFeaturesSummary(ProcessingResult.FeaturesSummary.ERROR_IN_FEATURES);
        }
    }

    private void setUnsuccessfulProcessing() {
        this.setUnsuccessfulValidation();
        this.setUnsuccessfulMetadataFixing();
        this.setUnsuccessfulFeatureExtracting();
    }
}

