/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.config;

public enum ProcessingType {
    VALIDATING_AND_FEATURES("validationAndFeatures", "Validation & Features"),
    VALIDATING("validation", "Validation"),
    FEATURES("features", "Features");

    private final String value;
    private final String text;

    private ProcessingType(String value, String text) {
        this.value = value;
        this.text = text;
    }

    public static ProcessingType getType(boolean isValidation, boolean isFeatures) {
        if (isValidation) {
            if (isFeatures) {
                return VALIDATING_AND_FEATURES;
            }
            return VALIDATING;
        }
        if (isFeatures) {
            return FEATURES;
        }
        throw new IllegalArgumentException("Processing type should contain at least one process");
    }

    public boolean isValidating() {
        return this == VALIDATING || this == VALIDATING_AND_FEATURES;
    }

    public boolean isFeatures() {
        return this == FEATURES || this == VALIDATING_AND_FEATURES;
    }

    public static ProcessingType fromString(String toParse) {
        for (ProcessingType processingType : ProcessingType.values()) {
            if (!processingType.toString().equalsIgnoreCase(toParse)) continue;
            return processingType;
        }
        throw new IllegalArgumentException("String can't be parsed into ProcessingType");
    }

    public String toText() {
        return this.text;
    }

    public String toString() {
        return this.value;
    }

    public static class Constants {
        public static final String TEXT_VALIDATING_AND_FEATURES = "Validation & Features";
        public static final String TEXT_VALIDATING = "Validation";
        public static final String TEXT_FEATURES = "Features";
        public static final String VALIDATING_AND_FEATURES = "validationAndFeatures";
        public static final String VALIDATING = "validation";
        public static final String FEATURES = "features";
    }
}

