/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.File;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="item")
public class ItemDetails {
    static final ItemDetails DEFAULT = new ItemDetails();
    @XmlElement
    private final String name;
    @XmlAttribute
    private final long size;

    private ItemDetails() {
        this("unknown");
    }

    private ItemDetails(String name) {
        this(name, -1L);
    }

    private ItemDetails(String name, long size) {
        this.name = name;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public static ItemDetails fromFile(File file) {
        return ItemDetails.fromValues(file.getAbsolutePath(), file.length());
    }

    public static ItemDetails fromValues(String name) {
        return ItemDetails.fromValues(name, -1L);
    }

    public static ItemDetails fromValues(String name, long size) {
        if (name == null) {
            throw new NullPointerException("Parameter name can not be null.");
        }
        return new ItemDetails(name, size);
    }

    public static void toXml(ItemDetails toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ItemDetails.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ItemDetails.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }
}

