/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import java.util.Formatter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.verapdf.features.tools.FeaturesCollection;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.verapdf.report.FeaturesReport;
import org.verapdf.report.ItemDetails;
import org.verapdf.report.MetadataFixesReport;
import org.verapdf.report.ValidationReport;

@XmlRootElement(name="report")
public class MachineReadableReport {
    private static final long MS_IN_SEC = 1000L;
    private static final int SEC_IN_MIN = 60;
    private static final long MS_IN_MIN = 60000L;
    private static final int MIN_IN_HOUR = 60;
    private static final long MS_IN_HOUR = 3600000L;
    @XmlAttribute
    private final Date creationDate;
    @XmlAttribute
    private final String processingTime;
    @XmlElement
    private final ItemDetails itemDetails;
    @XmlElement
    private final ValidationReport validationReport;
    @XmlElement
    private final MetadataFixesReport metadataFixesReport;
    @XmlElement
    private final FeaturesReport pdfFeaturesReport;

    private MachineReadableReport() {
        this(ItemDetails.DEFAULT, ValidationReport.fromValues(Profiles.defaultProfile(), null, false, 0), "", null, null);
    }

    private MachineReadableReport(ItemDetails itemDetails, ValidationReport report, String processingTime, FeaturesReport featuresReport, MetadataFixesReport metadataFixesReport) {
        this.itemDetails = itemDetails;
        this.validationReport = report;
        this.creationDate = new Date();
        this.processingTime = processingTime;
        this.pdfFeaturesReport = featuresReport;
        this.metadataFixesReport = metadataFixesReport;
    }

    public static MachineReadableReport fromValues(File file, ValidationProfile profile, ValidationResult validationResult, boolean reportPassedChecks, int maxFailuresDisplayed, MetadataFixerResult fixerResult, FeaturesCollection collection, long processingTime) {
        ValidationReport validationReport = null;
        if (validationResult != null) {
            validationReport = ValidationReport.fromValues(profile, validationResult, reportPassedChecks, maxFailuresDisplayed);
        }
        MetadataFixesReport fixesReport = MetadataFixesReport.fromValues(fixerResult);
        FeaturesReport featuresReport = FeaturesReport.fromValues(collection);
        return new MachineReadableReport(ItemDetails.fromFile(file), validationReport, MachineReadableReport.getProcessingTime(processingTime), featuresReport, fixesReport);
    }

    public static MachineReadableReport fromValues(ItemDetails item, ValidationProfile profile, ValidationResult validationResult, boolean reportPassedChecks, int maxFailuresDisplayed, MetadataFixerResult fixerResult, FeaturesCollection collection, long processingTime) {
        ValidationReport validationReport = null;
        if (validationResult != null) {
            validationReport = ValidationReport.fromValues(profile, validationResult, reportPassedChecks, maxFailuresDisplayed);
        }
        FeaturesReport featuresReport = FeaturesReport.fromValues(collection);
        MetadataFixesReport fixesReport = MetadataFixesReport.fromValues(fixerResult);
        return new MachineReadableReport(item, validationReport, MachineReadableReport.getProcessingTime(processingTime), featuresReport, fixesReport);
    }

    public static void toXml(MachineReadableReport toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = MachineReadableReport.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MachineReadableReport.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }

    private static String getProcessingTime(long processTime) {
        String res;
        long processingTime = processTime;
        Long hours = processingTime / 3600000L;
        Long mins = (processingTime %= 3600000L) / 60000L;
        Long sec = (processingTime %= 60000L) / 1000L;
        Long ms = processingTime %= 1000L;
        try (Formatter formatter = new Formatter();){
            formatter.format("%02d:", hours);
            formatter.format("%02d:", mins);
            formatter.format("%02d.", sec);
            formatter.format("%03d", ms);
            res = formatter.toString();
        }
        return res;
    }
}

