/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.Rule;
import org.verapdf.pdfa.validation.RuleId;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.verapdf.report.RuleSummary;

public class ValidationDetails {
    @XmlAttribute
    private final int passedRules;
    @XmlAttribute
    private final int failedRules;
    @XmlAttribute
    private final int passedChecks;
    @XmlAttribute
    private final int failedChecks;
    @XmlElement(name="rule")
    private final Set<RuleSummary> ruleSummaries;

    private ValidationDetails(int passedRules, int failedRules, int passedChecks, int failedChecks, Set<RuleSummary> ruleSummaries) {
        this.passedRules = passedRules;
        this.failedRules = failedRules;
        this.passedChecks = passedChecks;
        this.failedChecks = failedChecks;
        this.ruleSummaries = new HashSet<RuleSummary>(ruleSummaries);
    }

    private ValidationDetails() {
        this(0, 0, 0, 0, new HashSet<RuleSummary>());
    }

    static ValidationDetails fromValues(ValidationProfile profile, ValidationResult result, boolean logPassedChecks, int maxNumberOfDisplayedFailedChecks) {
        Map<RuleId, Set<TestAssertion>> assertionMap = ValidationDetails.mapAssertionsByRule(result.getTestAssertions());
        HashSet<RuleSummary> ruleSummaries = new HashSet<RuleSummary>();
        int passedRules = 0;
        int passedChecks = 0;
        int failedRules = 0;
        int failedChecks = 0;
        for (Rule rule : profile.getRules()) {
            RuleSummary summary = RuleSummary.uncheckedInstance(rule.getRuleId(), rule.getDescription(), rule.getObject(), rule.getTest());
            if (assertionMap.containsKey(rule.getRuleId())) {
                summary = RuleSummary.fromValues(rule.getRuleId(), rule.getDescription(), rule.getObject(), rule.getTest(), assertionMap.get(rule.getRuleId()), logPassedChecks, maxNumberOfDisplayedFailedChecks);
            }
            passedChecks += summary.getPassedChecks();
            failedChecks += summary.getFailedChecks();
            if (summary.getRuleStatus() == TestAssertion.Status.PASSED) {
                ++passedRules;
                if (!logPassedChecks) continue;
                ruleSummaries.add(summary);
                continue;
            }
            ++failedRules;
            ruleSummaries.add(summary);
        }
        return new ValidationDetails(passedRules, failedRules, passedChecks, failedChecks, ruleSummaries);
    }

    private static Map<RuleId, Set<TestAssertion>> mapAssertionsByRule(Set<TestAssertion> assertions) {
        HashMap<RuleId, Set<TestAssertion>> assertionMap = new HashMap<RuleId, Set<TestAssertion>>();
        for (TestAssertion assertion : assertions) {
            if (assertionMap.containsKey(assertion.getRuleId())) {
                ((Set)assertionMap.get(assertion.getRuleId())).add(assertion);
                continue;
            }
            HashSet<TestAssertion> assertionSet = new HashSet<TestAssertion>();
            assertionSet.add(assertion);
            assertionMap.put(assertion.getRuleId(), assertionSet);
        }
        return assertionMap;
    }
}

