/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.filters.io;

import java.io.IOException;
import java.util.Arrays;
import org.verapdf.as.filters.ASInFilter;
import org.verapdf.as.io.ASInputStream;

public class ASBufferingInFilter
extends ASInFilter {
    public static final int BF_BUFFER_SIZE = 2048;
    private int bufferCapacity;
    protected byte[] internalBuffer;
    private int bufferBegin;
    private int bufferEnd;

    public ASBufferingInFilter(ASInputStream stream) throws IOException {
        this(stream, 2048);
    }

    public ASBufferingInFilter(ASInputStream stream, int buffCapacity) throws IOException {
        super(stream);
        this.bufferCapacity = buffCapacity;
        this.internalBuffer = new byte[buffCapacity];
        this.bufferBegin = 0;
        this.bufferEnd = 0;
    }

    public ASBufferingInFilter(ASBufferingInFilter filter) {
        super(filter);
        this.bufferCapacity = filter.bufferCapacity;
        this.internalBuffer = new byte[this.bufferCapacity];
        this.bufferBegin = filter.bufferBegin;
        this.bufferEnd = filter.bufferEnd;
        if (this.bufferSize() > 0) {
            this.internalBuffer = Arrays.copyOfRange(filter.internalBuffer, filter.bufferBegin, filter.bufferEnd);
        }
    }

    public int processBuffer(int bytesToProcess) {
        int actuallyProcessed = Math.min(bytesToProcess, this.bufferSize());
        this.bufferBegin += bytesToProcess;
        return actuallyProcessed;
    }

    public long feedBuffer(int bytesToRead) throws IOException {
        if (this.getInputStream() == null) {
            return -1L;
        }
        bytesToRead = Math.min(bytesToRead, this.bufferCapacity);
        long actuallyRead = this.getInputStream().read(this.internalBuffer, bytesToRead);
        this.bufferBegin = 0;
        this.bufferEnd = (int)actuallyRead;
        return actuallyRead;
    }

    public long addToBuffer(int bytesToAdd) throws IOException {
        if (this.getInputStream() == null) {
            return -1L;
        }
        bytesToAdd = Math.min(bytesToAdd, this.bufferCapacity - this.bufferEnd);
        byte[] toAdd = new byte[bytesToAdd];
        long actuallyRead = this.getInputStream().read(toAdd, bytesToAdd);
        System.arraycopy(toAdd, 0, this.internalBuffer, this.bufferEnd, bytesToAdd);
        this.bufferEnd += bytesToAdd;
        return actuallyRead;
    }

    public int getBufferBegin() {
        return this.bufferBegin;
    }

    public int getBufferEnd() {
        return this.bufferEnd;
    }

    public byte bufferPop() {
        return this.internalBuffer[this.bufferBegin++];
    }

    public int bufferPopArray(byte[] buffer, int read) throws IOException {
        int actualRead = Math.min(read, this.bufferSize());
        if (actualRead == -1) {
            return -1;
        }
        if (buffer.length < actualRead) {
            throw new IOException("Passed buffer is too small");
        }
        System.arraycopy(this.internalBuffer, this.bufferBegin, buffer, 0, actualRead);
        this.bufferBegin += actualRead;
        return actualRead;
    }

    public int bufferSize() {
        return this.bufferEnd - this.bufferBegin;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    @Override
    public void closeResource() throws IOException {
        super.closeResource();
        this.bufferBegin = 0;
        this.bufferEnd = 0;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bufferBegin = 0;
        this.bufferEnd = 0;
    }

    public static byte[] concatenate(byte[] one, int lengthOne, byte[] two, int lengthTwo) {
        if (lengthTwo == -1) {
            lengthTwo = 0;
        }
        if (lengthOne == -1) {
            lengthOne = 0;
        }
        if (lengthOne == 0) {
            return Arrays.copyOfRange(two, 0, lengthTwo);
        }
        if (lengthTwo == 0) {
            return Arrays.copyOfRange(one, 0, lengthOne);
        }
        byte[] res = new byte[lengthOne + lengthTwo];
        System.arraycopy(one, 0, res, 0, lengthOne);
        System.arraycopy(two, 0, res, lengthOne, lengthTwo);
        return res;
    }

    protected void decode() throws IOException {
    }
}

