/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.tools.IntReference;

public class ASFileInStream
extends ASInputStream {
    private RandomAccessFile stream;
    private long offset;
    private long size;
    private long curPos;
    private IntReference numOfFileUsers;
    private boolean isTempFile;
    private String filePath;

    public ASFileInStream(RandomAccessFile stream, long offset, long size, IntReference numOfFileUsers, String filePath, boolean isTempFile) {
        this.stream = stream;
        this.offset = offset;
        this.size = size;
        this.curPos = 0L;
        this.numOfFileUsers = numOfFileUsers;
        this.numOfFileUsers.increment();
        this.isTempFile = isTempFile;
        this.filePath = filePath;
    }

    @Override
    public int read() throws IOException {
        if (this.curPos < this.size) {
            long prev = this.stream.getFilePointer();
            this.stream.seek(this.offset + this.curPos);
            int result = this.stream.readByte() & 0xFF;
            ++this.curPos;
            this.stream.seek(prev);
            return result;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int sizeToRead) throws IOException {
        if (sizeToRead == 0 || this.size != (long)this.nPos && this.curPos >= this.size) {
            return -1;
        }
        if (this.size != (long)this.nPos && (long)sizeToRead > this.size - this.curPos) {
            sizeToRead = (int)(this.size - this.curPos);
        }
        long prev = this.stream.getFilePointer();
        this.stream.seek(this.offset + this.curPos);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            byte[] temp = new byte[1024];
            while (sizeToRead > 0 && (n = this.stream.read(temp, 0, Math.min(temp.length, sizeToRead))) != -1) {
                output.write(temp, 0, n);
                sizeToRead -= n;
            }
            byte[] byteArray = output.toByteArray();
            int count = byteArray.length;
            System.arraycopy(byteArray, 0, buffer, 0, count);
            this.stream.seek(prev);
            this.curPos += (long)count;
            int n2 = count;
            return n2;
        }
    }

    @Override
    public int skip(int size) throws IOException {
        if (size == 0 || this.size != (long)this.nPos && this.size <= this.curPos) {
            return 0;
        }
        if (this.size != (long)this.nPos && (long)size > this.size - this.curPos) {
            size = (int)(this.size - this.curPos);
        }
        this.curPos += (long)size;
        return size;
    }

    @Override
    public void closeResource() throws IOException {
        this.numOfFileUsers.decrement();
        if (this.numOfFileUsers.equals(0)) {
            this.stream.close();
            if (this.isTempFile) {
                File tmp = new File(this.filePath);
                tmp.delete();
            }
        }
    }

    @Override
    public void reset() {
        this.curPos = 0L;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

