/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.cli.VeraPdfCliProcessor;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.VeraGreenfieldFoundryProvider;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.ProfileDirectory;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;

public final class VeraPdfCli {
    private static final Logger logger = Logger.getLogger(VeraCliArgParser.class.getCanonicalName());
    private static final ConfigManager configManager = Applications.createAppConfigManager();
    private static final int MEGABYTE = 0x100000;
    private static final String APP_NAME = "veraPDF";
    private static final String FLAVOURS_HEADING = "veraPDF supported PDF/A profiles:";
    private static final ProfileDirectory PROFILES = Profiles.getVeraProfileDirectory();

    private VeraPdfCli() {
    }

    public static void main(String[] args) throws VeraPDFException, IOException {
        VeraGreenfieldFoundryProvider.initialise();
        MemoryMXBean memoryMan = ManagementFactory.getMemoryMXBean();
        ReleaseDetails.addDetailsFromResource("org/verapdf/release/app.properties");
        VeraCliArgParser cliArgParser = new VeraCliArgParser();
        JCommander jCommander = new JCommander(cliArgParser);
        jCommander.setProgramName(APP_NAME);
        try {
            jCommander.parse(args);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            VeraPdfCli.showVersionInfo();
            jCommander.usage();
            System.exit(1);
        }
        if (cliArgParser.isHelp()) {
            VeraPdfCli.showVersionInfo();
            jCommander.usage();
            System.exit(0);
        }
        VeraPdfCli.messagesFromParser(cliArgParser);
        if (VeraPdfCli.isProcess(cliArgParser)) {
            try {
                VeraPdfCliProcessor processor = VeraPdfCliProcessor.createProcessorFromArgs(cliArgParser, configManager);
                if (args.length == 0) {
                    jCommander.usage();
                }
                processor.processPaths(cliArgParser.getPdfPaths());
            }
            catch (OutOfMemoryError oome) {
                String message = "The JVM appears to have run out of memory";
                logger.log(Level.WARNING, "The JVM appears to have run out of memory", oome);
                MemoryUsage heapUsage = memoryMan.getHeapMemoryUsage();
                long maxMemory = heapUsage.getMax() / 0x100000L;
                long usedMemory = heapUsage.getUsed() / 0x100000L;
                System.out.println("The JVM appears to have run out of memory");
                System.out.println("Memory Use: " + usedMemory + "M/" + maxMemory + "M");
                System.out.println("To increase the memory available to the JVM please assign the JAVA_OPTS environment variable.");
                System.out.println("The examples below increase the maximum heap available to the JVM to 2GB:");
                System.out.println(" - Mac or Linux users: ");
                System.out.println("   export JAVA_OPTS=\"-Xmx2048m\"");
                System.out.println(" - Windows users: ");
                System.out.println("   SET JAVA_OPTS=\"-Xmx2048m\"");
                System.exit(1);
            }
        }
    }

    private static void messagesFromParser(VeraCliArgParser parser) {
        if (parser.listProfiles()) {
            VeraPdfCli.listProfiles();
        }
        if (parser.showVersion()) {
            VeraPdfCli.showVersionInfo();
        }
    }

    private static void listProfiles() {
        System.out.println(FLAVOURS_HEADING);
        EnumSet<PDFAFlavour> flavs = EnumSet.copyOf(PROFILES.getPDFAFlavours());
        for (PDFAFlavour flav : flavs) {
            ValidationProfile profile = PROFILES.getValidationProfileByFlavour(flav);
            System.out.println("  " + profile.getPDFAFlavour().getId() + " - " + profile.getDetails().getName());
        }
        System.out.println();
    }

    private static void showVersionInfo() {
        ReleaseDetails details = ReleaseDetails.byId("gui");
        System.out.println("veraPDF " + details.getVersion());
        System.out.println("Built: " + details.getBuildDate());
        System.out.println(ReleaseDetails.rightsStatement());
        System.out.println();
    }

    private static boolean isProcess(VeraCliArgParser parser) {
        return !parser.getPdfPaths().isEmpty() || !parser.isHelp() && !parser.listProfiles() && !parser.showVersion();
    }
}

