/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDAnnotation;

public class GFAnnotationFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDAnnotation annot;
    private String id;
    private String popupId;
    private Set<String> formXObjects;

    public GFAnnotationFeaturesObject(PDAnnotation annot, String id, String popupId, Set<String> formXObjects) {
        this.annot = annot;
        this.id = id;
        this.popupId = popupId;
        this.formXObjects = formXObjects;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.ANNOTATION;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.annot != null && !this.annot.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("annotation");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            GFCreateNodeHelper.addNotEmptyNode("subType", this.annot.getSubtype(), root);
            GFCreateNodeHelper.addBoxFeature("rectangle", this.annot.getRect(), root);
            GFCreateNodeHelper.addNotEmptyNode("contents", this.annot.getContents(), root);
            GFCreateNodeHelper.addNotEmptyNode("annotationName", this.annot.getAnnotationName(), root);
            GFCreateNodeHelper.addNotEmptyNode("modifiedDate", this.annot.getModDate(), root);
            if (this.formXObjects != null && !this.formXObjects.isEmpty()) {
                FeatureTreeNode resources = root.addChild("resources");
                for (String xObjID : this.formXObjects) {
                    if (xObjID == null) continue;
                    FeatureTreeNode xObjNode = resources.addChild("xobject");
                    xObjNode.setAttribute(ID, xObjID);
                }
            }
            if (this.popupId != null) {
                FeatureTreeNode popup = root.addChild("popup");
                popup.setAttribute(ID, this.popupId);
            }
            GFCreateNodeHelper.addDeviceColorSpaceNode("color", this.annot.getColor(), root, collection);
            GFCreateNodeHelper.addNotEmptyNode("invisible", String.valueOf(this.annot.isInvisible()), root);
            GFCreateNodeHelper.addNotEmptyNode("hidden", String.valueOf(this.annot.isHidden()), root);
            GFCreateNodeHelper.addNotEmptyNode("print", String.valueOf(this.annot.isPrinted()), root);
            GFCreateNodeHelper.addNotEmptyNode("noZoom", String.valueOf(this.annot.isNoZoom()), root);
            GFCreateNodeHelper.addNotEmptyNode("noRotate", String.valueOf(this.annot.isNoRotate()), root);
            GFCreateNodeHelper.addNotEmptyNode("noView", String.valueOf(this.annot.isNoView()), root);
            GFCreateNodeHelper.addNotEmptyNode("readOnly", String.valueOf(this.annot.isReadOnly()), root);
            GFCreateNodeHelper.addNotEmptyNode("locked", String.valueOf(this.annot.isLocked()), root);
            GFCreateNodeHelper.addNotEmptyNode("toggleNoView", String.valueOf(this.annot.isToggleNoView()), root);
            GFCreateNodeHelper.addNotEmptyNode("toggleNoView", String.valueOf(this.annot.isLockedContents()), root);
            collection.addNewFeatureTree(FeatureObjectType.ANNOTATION, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }
}

