/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Arrays;
import java.util.Calendar;
import java.util.TreeSet;
import org.verapdf.as.ASAtom;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.tools.TypeConverter;

public class GFInfoDictFeaturesObject
implements IFeaturesObject {
    private static final ASAtom[] predefinedKeys = new ASAtom[]{ASAtom.TITLE, ASAtom.AUTHOR, ASAtom.SUBJECT, ASAtom.KEYWORDS, ASAtom.CREATOR, ASAtom.PRODUCER, ASAtom.CREATION_DATE, ASAtom.MOD_DATE, ASAtom.TRAPPED};
    private static final String ENTRY = "entry";
    private static final String KEY = "key";
    private COSObject info;

    public GFInfoDictFeaturesObject(COSObject info) {
        this.info = info;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.INFORMATION_DICTIONARY;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.info != null && this.info.getType() == COSObjType.COS_DICT) {
            Calendar mdDateCal;
            FeatureTreeNode modDate;
            String mdDate;
            Calendar crDateCal;
            FeatureTreeNode creationDate;
            FeatureTreeNode root = FeatureTreeNode.createRootNode("informationDict");
            GFInfoDictFeaturesObject.addEntry("Title", this.info.getStringKey(ASAtom.TITLE), root);
            GFInfoDictFeaturesObject.addEntry("Author", this.info.getStringKey(ASAtom.AUTHOR), root);
            GFInfoDictFeaturesObject.addEntry("Subject", this.info.getStringKey(ASAtom.SUBJECT), root);
            GFInfoDictFeaturesObject.addEntry("Keywords", this.info.getStringKey(ASAtom.KEYWORDS), root);
            GFInfoDictFeaturesObject.addEntry("Creator", this.info.getStringKey(ASAtom.CREATOR), root);
            GFInfoDictFeaturesObject.addEntry("Producer", this.info.getStringKey(ASAtom.PRODUCER), root);
            String crDate = this.info.getStringKey(ASAtom.CREATION_DATE);
            if (crDate != null && (creationDate = GFCreateNodeHelper.createDateNode(ENTRY, root, crDateCal = TypeConverter.parseDate(crDate), collection)) != null) {
                creationDate.setAttribute(KEY, "CreationDate");
            }
            if ((mdDate = this.info.getStringKey(ASAtom.MOD_DATE)) != null && (modDate = GFCreateNodeHelper.createDateNode(ENTRY, root, mdDateCal = TypeConverter.parseDate(mdDate), collection)) != null) {
                modDate.setAttribute(KEY, "ModDate");
            }
            GFInfoDictFeaturesObject.addEntry("Trapped", this.info.getNameKey(ASAtom.TRAPPED), root);
            TreeSet<ASAtom> keys = new TreeSet<ASAtom>(this.info.getKeySet());
            keys.removeAll(Arrays.asList(predefinedKeys));
            for (ASAtom key : keys) {
                GFInfoDictFeaturesObject.addEntry(key.getValue(), this.info.getStringKey(key), root);
            }
            collection.addNewFeatureTree(FeatureObjectType.INFORMATION_DICTIONARY, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private static void addEntry(String name, ASAtom value, FeatureTreeNode root) throws FeatureParsingException {
        if (value != null) {
            GFInfoDictFeaturesObject.addEntry(name, value.getValue(), root);
        }
    }

    private static void addEntry(String name, String value, FeatureTreeNode root) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode entry = root.addChild(ENTRY);
            entry.setValue(value);
            entry.setAttribute(KEY, name);
        }
    }
}

