/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDOutputIntent;

public class GFOutputIntentsFeaturesObject
implements IFeaturesObject {
    private PDOutputIntent outInt;
    private String iccProfileID;

    public GFOutputIntentsFeaturesObject(PDOutputIntent outInt, String iccProfileID) {
        this.outInt = outInt;
        this.iccProfileID = iccProfileID;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.OUTPUTINTENT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.outInt != null && !this.outInt.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("outputIntent");
            GFCreateNodeHelper.addNotEmptyNode("subtype", this.outInt.getSubtype(), root);
            GFCreateNodeHelper.addNotEmptyNode("outputCondition", this.outInt.getOutputCondition(), root);
            GFCreateNodeHelper.addNotEmptyNode("outputConditionIdentifier", this.outInt.getOutputConditionIdentifier(), root);
            GFCreateNodeHelper.addNotEmptyNode("registryName", this.outInt.getRegistryName(), root);
            GFCreateNodeHelper.addNotEmptyNode("info", this.outInt.getInfo(), root);
            if (this.iccProfileID != null) {
                FeatureTreeNode destOutInt = root.addChild("destOutputIntent");
                destOutInt.setAttribute("id", this.iccProfileID);
            }
            collection.addNewFeatureTree(FeatureObjectType.OUTPUTINTENT, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }
}

