/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.patterns.PDShading;

public class GFShadingFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDShading shading;
    private String id;
    private String colorSpaceChild;

    public GFShadingFeaturesObject(PDShading shading, String id, String colorSpaceChild) {
        this.shading = shading;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.SHADING;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.shading != null && !this.shading.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("shading");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.addChild("shadingType").setValue(String.valueOf(this.shading.getShadingType()));
            if (this.colorSpaceChild != null) {
                FeatureTreeNode shadingClr = root.addChild("colorSpace");
                shadingClr.setAttribute(ID, this.colorSpaceChild);
            }
            GFCreateNodeHelper.addBoxFeature("bbox", this.shading.getBBox(), root);
            root.addChild("antiAlias").setValue(String.valueOf(this.shading.getAntiAlias()));
            collection.addNewFeatureTree(FeatureObjectType.SHADING, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }
}

