/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.verapdf.as.ASAtom;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.gf.tools.ColorComponent;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDMetadata;

public final class GFCreateNodeHelper {
    private static final Logger LOGGER = Logger.getLogger(GFCreateNodeHelper.class.getCanonicalName());
    private static final String LLX = "llx";
    private static final String LLY = "lly";
    private static final String URX = "urx";
    private static final String URY = "ury";

    private GFCreateNodeHelper() {
    }

    private static String getXMLFormat(Calendar calendar) throws DatatypeConfigurationException {
        GregorianCalendar greg = new GregorianCalendar(Locale.US);
        greg.setTime(calendar.getTime());
        greg.setTimeZone(calendar.getTimeZone());
        XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(greg);
        return xmlCalendar.toXMLFormat();
    }

    public static FeatureTreeNode createDateNode(String nodeName, FeatureTreeNode parent, Calendar date, FeatureExtractionResult collection) throws FeatureParsingException {
        FeatureTreeNode modificationDate = null;
        if (date != null) {
            modificationDate = parent.addChild(nodeName);
            try {
                modificationDate.setValue(GFCreateNodeHelper.getXMLFormat(date));
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.log(Level.FINE, "DatatypeFactory implementation not available or can't be instantiated", e);
                ErrorsHelper.addErrorIntoCollection(collection, modificationDate, e.getMessage());
            }
        }
        return modificationDate;
    }

    public static FeatureTreeNode addBoxFeature(String name, double[] box, FeatureTreeNode parent) throws FeatureParsingException {
        FeatureTreeNode boxNode = null;
        if (box != null && box.length >= 4) {
            boxNode = parent.addChild(name);
            boxNode.setAttribute(LLX, String.valueOf(box[0]));
            boxNode.setAttribute(LLY, String.valueOf(box[1]));
            boxNode.setAttribute(URX, String.valueOf(box[2]));
            boxNode.setAttribute(URY, String.valueOf(box[3]));
        }
        return boxNode;
    }

    public static FeatureTreeNode addNotEmptyNode(String name, String value, FeatureTreeNode parent) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode node = parent.addChild(name);
            node.setValue(value);
            return node;
        }
        return null;
    }

    public static FeatureTreeNode addNotEmptyNode(String name, ASAtom value, FeatureTreeNode parent) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode node = parent.addChild(name);
            node.setValue(value.getValue());
            return node;
        }
        return null;
    }

    public static FeatureTreeNode addNotEmptyNode(String name, COSObject value, FeatureTreeNode parent) throws FeatureParsingException {
        if (!(name == null || value == null || value.empty() || value.getType() != COSObjType.COS_NAME && value.getType() != COSObjType.COS_STRING)) {
            FeatureTreeNode node = parent.addChild(name);
            node.setValue(value.getString());
            return node;
        }
        return null;
    }

    public static FeatureTreeNode addDeviceColorSpaceNode(String name, double[] color, FeatureTreeNode parent, FeatureExtractionResult collection) throws FeatureParsingException {
        if (name == null || color == null) {
            return null;
        }
        FeatureTreeNode colorNode = parent.addChild(name);
        boolean typeDefined = false;
        for (ColorComponent component : ColorComponent.values()) {
            if (component.getSize() != color.length) continue;
            typeDefined = true;
            colorNode.setAttributes(component.createAttributesMap(color));
        }
        if (!typeDefined) {
            ErrorsHelper.addErrorIntoCollection(collection, colorNode, "Can not define color type");
        }
        return colorNode;
    }

    public static void parseIDSet(Set<String> set, String elementName, String setName, FeatureTreeNode root) throws FeatureParsingException {
        if (set != null && !set.isEmpty()) {
            FeatureTreeNode setNode = setName == null ? root : root.addChild(setName);
            for (String entry : set) {
                if (entry == null) continue;
                FeatureTreeNode entryNode = setNode.addChild(elementName);
                entryNode.setAttribute("id", entry);
            }
        }
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }

    public static FeatureTreeNode parseMetadata(PDMetadata metadata, String nodeName, FeatureTreeNode parent, FeatureExtractionResult collection) throws FeatureParsingException {
        if (metadata == null || metadata.empty()) {
            return null;
        }
        FeatureTreeNode node = parent.addMetadataChild(nodeName);
        try {
            InputStream stream = metadata.getStream();
            if (stream != null) {
                int r;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((r = stream.read(buffer)) != -1) {
                    out.write(buffer, 0, r);
                }
                byte[] bStream = out.toByteArray();
                String hexString = DatatypeConverter.printHexBinary((byte[])bStream);
                node.setValue(hexString);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error while obtaining unfiltered metadata stream", e);
            ErrorsHelper.addErrorIntoCollection(collection, node, e.getMessage());
        }
        return node;
    }

    public static void parseMatrix(double[] array, FeatureTreeNode parent) throws FeatureParsingException {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                FeatureTreeNode element = parent.addChild("element");
                element.setAttribute("index", String.valueOf(i + 1));
                element.setAttribute("value", String.valueOf(array[i]));
            }
        }
    }

    public static String getStringFromASAtom(ASAtom asAtom) {
        return asAtom == null ? null : asAtom.getValue();
    }
}

