/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.fonts;

import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.pd.font.GFPDTrueTypeFont;
import org.verapdf.gf.model.impl.pd.font.GFPDType0Font;
import org.verapdf.gf.model.impl.pd.font.GFPDType1Font;
import org.verapdf.gf.model.impl.pd.font.GFPDType3Font;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.font.PDType3Font;
import org.verapdf.pd.font.truetype.PDTrueTypeFont;
import org.verapdf.pd.font.type1.PDType1Font;

public class FontFactory {
    public static final String CID_FONT_TYPE_0 = "CIDFontType0";
    public static final String TYPE_1 = "Type1";
    public static final String MM_TYPE_1 = "MMType1";
    public static final String TYPE_3 = "Type3";
    public static final String TRUE_TYPE = "TrueType";
    public static final String CID_FONT_TYPE_2 = "CIDFontType2";

    private FontFactory() {
    }

    public static org.verapdf.model.pdlayer.PDFont parseFont(PDFont rawFont, RenderingMode renderingMode, PDResourcesHandler resources) {
        if (rawFont == null) {
            return null;
        }
        switch (rawFont.getSubtype().getValue()) {
            case "CIDFontType0": 
            case "CIDFontType2": {
                return new GFPDType0Font((PDType0Font)rawFont, renderingMode);
            }
            case "Type1": 
            case "MMType1": {
                return new GFPDType1Font((PDType1Font)rawFont, renderingMode);
            }
            case "Type3": {
                PDResources fontResources = ((PDType3Font)rawFont).getResources();
                PDResourcesHandler pdResources = resources.getExtendedResources(fontResources);
                return new GFPDType3Font((PDType3Font)rawFont, renderingMode, pdResources);
            }
            case "TrueType": {
                return new GFPDTrueTypeFont((PDTrueTypeFont)rawFont, renderingMode);
            }
        }
        return null;
    }
}

