/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.pd.font.GFPDCIDFont;
import org.verapdf.gf.model.impl.pd.font.GFPDCmap;
import org.verapdf.gf.model.impl.pd.font.GFPDFont;
import org.verapdf.model.pdlayer.PDCMap;
import org.verapdf.model.pdlayer.PDType0Font;
import org.verapdf.pd.font.PDCIDFont;
import org.verapdf.pd.font.PDFont;

public class GFPDType0Font
extends GFPDFont
implements PDType0Font {
    private static final Logger LOGGER = Logger.getLogger(GFPDType0Font.class.getCanonicalName());
    public static final String TYPE_0_FONT_TYPE = "PDType0Font";
    public static final String DESCENDANT_FONTS = "DescendantFonts";
    public static final String ENCODING = "Encoding";
    private org.verapdf.model.pdlayer.PDCIDFont descendantFont = this.getDescendantFont();
    private PDCIDFont cidFont;

    public GFPDType0Font(org.verapdf.pd.font.PDType0Font font, RenderingMode renderingMode) {
        super(font, renderingMode, TYPE_0_FONT_TYPE);
        ((org.verapdf.pd.font.PDType0Font)this.pdFont).setFontProgramFromDescendant(this.cidFont);
        this.fontProgramParsed = this.descendantFont != null && ((GFPDCIDFont)this.descendantFont).isFontProgramParsed();
        this.pdFont.setSuccessfullyParsed(this.fontProgramParsed);
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "DescendantFonts": {
                return this.getDescendantFonts();
            }
            case "Encoding": {
                return this.getEncoding();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDCIDFont> getDescendantFonts() {
        if (this.descendantFont != null) {
            ArrayList<org.verapdf.model.pdlayer.PDCIDFont> list = new ArrayList<org.verapdf.model.pdlayer.PDCIDFont>(1);
            list.add(this.descendantFont);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.pdlayer.PDCIDFont getDescendantFont() {
        COSDictionary cidFontDict = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getDescendantFont();
        if (cidFontDict != null) {
            PDCIDFont cidFont;
            this.cidFont = cidFont = new PDCIDFont(cidFontDict, ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap().getCMapFile(), this.pdFont.getFontProgram(), this.pdFont.isSuccessfullyParsed());
            GFPDCIDFont pdCIDFont = new GFPDCIDFont((PDFont)cidFont, this.renderingMode);
            return pdCIDFont;
        }
        return null;
    }

    private List<PDCMap> getEncoding() {
        if (((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap() != null) {
            GFPDCmap res = new GFPDCmap(((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap());
            ArrayList<GFPDCmap> list = new ArrayList<GFPDCmap>(1);
            list.add(res);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getareRegistryOrderingCompatible() {
        if (((org.verapdf.pd.font.PDType0Font)this.pdFont).getCIDSystemInfo() == null) {
            LOGGER.log(Level.SEVERE, "CID font dictionary doesn't contain CIDSystemInfo");
            return false;
        }
        if (((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap() == null) {
            LOGGER.log(Level.SEVERE, "Type 0 font dictionary doesn't contain Encoding");
            return false;
        }
        return this.isOrderingCompatible() && this.isRegistryCompatible();
    }

    @Override
    public Boolean getisSupplementCompatible() {
        if (((org.verapdf.pd.font.PDType0Font)this.pdFont).getCIDSystemInfo() == null) {
            LOGGER.log(Level.SEVERE, "CID font dictionary doesn't contain CIDSystemInfo");
            return false;
        }
        if (((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap() == null) {
            LOGGER.log(Level.SEVERE, "Type 0 font dictionary doesn't contain Encoding");
            return false;
        }
        Long fontSupplement = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCIDSystemInfo().getIntegerKey(ASAtom.SUPPLEMENT);
        Long cMapSupplement = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap().getSupplement();
        if (fontSupplement == null) {
            LOGGER.log(Level.SEVERE, "CIDSystemInfo dictionary doesn't contain Supplement entry.");
            return false;
        }
        return fontSupplement >= cMapSupplement;
    }

    @Override
    public String getcmapName() {
        org.verapdf.pd.font.cmap.PDCMap pdcMap = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap();
        if (pdcMap == null) {
            return "";
        }
        return pdcMap.getCMapName();
    }

    @Override
    public String getSubtype() {
        ASAtom subtype = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getType0FontDict().getNameKey(ASAtom.SUBTYPE);
        return subtype == null ? null : subtype.getValue();
    }

    private boolean isRegistryCompatible() {
        String fontRegistry = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCIDSystemInfo().getStringKey(ASAtom.REGISTRY);
        String cMapRegistry = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap().getRegistry();
        if (fontRegistry == null) {
            LOGGER.log(Level.SEVERE, "CIDSystemInfo dictionary doesn't contain Registry entry.");
            return false;
        }
        return fontRegistry.equals(cMapRegistry);
    }

    private boolean isOrderingCompatible() {
        String fontOrdering = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCIDSystemInfo().getStringKey(ASAtom.ORDERING);
        String cMapOrdering = ((org.verapdf.pd.font.PDType0Font)this.pdFont).getCMap().getOrdering();
        if (fontOrdering == null) {
            LOGGER.log(Level.SEVERE, "CIDSystemInfo dictionary doesn't contain Ordering entry.");
            return false;
        }
        return fontOrdering.equals(cMapOrdering);
    }
}

