/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.font.CIDWArray;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDCIDSystemInfo;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.truetype.CIDFontType2Program;

public class PDCIDFont
extends PDFont {
    private static final Logger LOGGER = Logger.getLogger(PDCIDFont.class.getCanonicalName());
    private static final Double DEFAULT_CID_FONT_WIDTH = 1000.0;
    protected CMap cMap;
    private CIDWArray widths;
    private PDCIDSystemInfo cidSystemInfo;

    public PDCIDFont(COSDictionary dictionary, CMap cMap) {
        super(dictionary);
        this.cMap = cMap;
    }

    public PDCIDFont(COSDictionary dictionary, CMap cMap, FontProgram fontProgram, boolean isFontParsed) {
        this(dictionary, cMap);
        this.fontProgram = fontProgram;
        this.isFontParsed = isFontParsed;
        if (fontProgram != null) {
            this.isFontParsed = true;
        }
    }

    protected PDCIDFont(COSDictionary dictionary) {
        super(dictionary);
    }

    public COSStream getCIDSet() {
        COSObject cidSet = this.fontDescriptor.getKey(ASAtom.CID_SET);
        return cidSet == null ? null : (COSStream)cidSet.getDirectBase();
    }

    public COSObject getCIDToGIDMap() {
        return this.dictionary.getKey(ASAtom.CID_TO_GID_MAP);
    }

    @Override
    public Double getWidth(int code) {
        Double res;
        if (this.widths == null) {
            COSObject w = this.dictionary.getKey(ASAtom.W);
            if (w.empty() || w.getType() != COSObjType.COS_ARRAY) {
                return 0.0;
            }
            this.widths = new CIDWArray((COSArray)w.getDirectBase());
        }
        if ((res = this.widths.getWidth(this.cMap.toCID(code))) == null) {
            COSObject dw = this.dictionary.getKey(ASAtom.DW);
            res = !dw.empty() ? dw.getReal() : DEFAULT_CID_FONT_WIDTH;
        }
        return res;
    }

    @Override
    public Double getDefaultWidth() {
        COSObject dw = this.dictionary.getKey(ASAtom.DW);
        if (dw.getType().isNumber()) {
            return dw.getReal();
        }
        return DEFAULT_CID_FONT_WIDTH;
    }

    @Override
    public int readCode(InputStream stream) throws IOException {
        if (this.cMap != null) {
            return this.cMap.getCodeFromStream(stream);
        }
        throw new IOException("No CMap for Type 0 font " + (this.getName() == null ? "" : this.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FontProgram getFontProgram() {
        if (this.isFontParsed) {
            return this.fontProgram;
        }
        this.isFontParsed = true;
        if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE2) && this.getSubtype() == ASAtom.CID_FONT_TYPE2) {
            COSStream trueTypeFontFile = this.fontDescriptor.getFontFile2();
            try (ASInputStream fontData = trueTypeFontFile.getData(COSStream.FilterFlags.DECODE);){
                FontProgram fontProgram = this.fontProgram = new CIDFontType2Program(fontData, this.cMap, this.getCIDToGIDMap());
                return fontProgram;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't read TrueType font program.", e);
            }
        } else if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE3)) {
            COSStream fontFile = this.fontDescriptor.getFontFile3();
            COSName subtype = (COSName)fontFile.getKey(ASAtom.SUBTYPE).getDirectBase();
            try (ASInputStream fontData = fontFile.getData(COSStream.FilterFlags.DECODE);){
                if (ASAtom.CID_FONT_TYPE0C == subtype.getName()) {
                    FontProgram x2 = this.fontProgram = new CFFFontProgram(fontData, this.getEncodingMapping(), this.cMap, this.isSubset());
                    return x2;
                }
                if (ASAtom.OPEN_TYPE == subtype.getName()) {
                    ASAtom fontName = this.getFontName();
                    if (fontName != ASAtom.TRUE_TYPE && fontName != ASAtom.CID_FONT_TYPE2) {
                        FontProgram fontProgram = this.fontProgram = new OpenTypeFontProgram(fontData, true, this.isSymbolic(), this.getEncoding(), this.cMap, this.isSubset());
                        return fontProgram;
                    }
                    FontProgram fontProgram = this.fontProgram = new OpenTypeFontProgram(fontData, false, this.isSymbolic(), this.getEncoding(), this.cMap, this.isSubset());
                    return fontProgram;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't read CFF font program.", e);
            }
        }
        this.fontProgram = null;
        return null;
    }

    public PDCIDSystemInfo getCIDSystemInfo() {
        if (this.cidSystemInfo != null) {
            return this.cidSystemInfo;
        }
        this.cidSystemInfo = new PDCIDSystemInfo(this.dictionary.getKey(ASAtom.CID_SYSTEM_INFO));
        return this.cidSystemInfo;
    }
}

