/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskType;
import org.verapdf.report.FeaturesReport;

public abstract class AbstractBatchHandler
implements BatchProcessingHandler {
    protected AbstractBatchHandler() {
    }

    @Override
    public void handleResult(ProcessorResult result) throws VeraPDFException {
        if (result == null) {
            throw new VeraPDFException("Arg result is null and can not be handled.");
        }
        this.resultStart(result);
        this.processTasks(result);
        this.resultEnd(result);
    }

    private void processTasks(ProcessorResult result) throws VeraPDFException {
        for (TaskType taskType : result.getTaskTypes()) {
            TaskResult taskResult = result.getResultForTask(taskType);
            if (!taskResult.isExecuted()) continue;
            switch (taskType) {
                case VALIDATE: {
                    if (taskResult.isSuccess()) {
                        this.validationSuccess(taskResult, result.getValidationResult());
                        break;
                    }
                    this.validationFailure(taskResult);
                    break;
                }
                case PARSE: {
                    if (taskResult.isSuccess()) {
                        this.parsingSuccess(taskResult);
                        break;
                    }
                    if (!result.isValidPdf()) {
                        this.parsingFailure(taskResult);
                        break;
                    }
                    this.pdfEncrypted(taskResult);
                    break;
                }
                case EXTRACT_FEATURES: {
                    if (taskResult.isSuccess()) {
                        this.featureSuccess(taskResult, result.getFeaturesReport());
                        break;
                    }
                    this.featureFailure(taskResult);
                    break;
                }
                case FIX_METADATA: {
                    if (taskResult.isSuccess()) {
                        this.fixerSuccess(taskResult, result.getFixerResult());
                        break;
                    }
                    this.fixerFailure(taskResult);
                    break;
                }
            }
        }
    }

    abstract void resultStart(ProcessorResult var1) throws VeraPDFException;

    abstract void parsingSuccess(TaskResult var1) throws VeraPDFException;

    abstract void parsingFailure(TaskResult var1) throws VeraPDFException;

    abstract void pdfEncrypted(TaskResult var1) throws VeraPDFException;

    abstract void validationSuccess(TaskResult var1, ValidationResult var2) throws VeraPDFException;

    abstract void validationFailure(TaskResult var1) throws VeraPDFException;

    abstract void featureSuccess(TaskResult var1, FeaturesReport var2) throws VeraPDFException;

    abstract void featureFailure(TaskResult var1) throws VeraPDFException;

    abstract void fixerSuccess(TaskResult var1, MetadataFixerResult var2) throws VeraPDFException;

    abstract void fixerFailure(TaskResult var1) throws VeraPDFException;

    abstract void resultEnd(ProcessorResult var1) throws VeraPDFException;
}

