/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.verapdf.core.VeraPDFException;
import org.verapdf.processor.AbstractBatchHandler;

public abstract class AbstractXmlHandler
extends AbstractBatchHandler {
    private static final Logger logger = Logger.getLogger(AbstractXmlHandler.class.getCanonicalName());
    protected static final String strmExcpMessTmpl = "XmlStreamException caught when %s output writer.";
    protected static final String unmarshalErrMessage = "Unmarshalling exception when streaming %s.";
    private static final String encoding = "utf-8";
    private static final String xmlVersion = "1.0";
    private static final String lineSepProp = "line.separator";
    private static final String newline = System.getProperty("line.separator");
    private static XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
    protected XMLStreamWriter writer;
    private final int indentSize;
    private int indent = 0;

    protected AbstractXmlHandler(Writer dest) throws VeraPDFException {
        this(dest, 2);
    }

    protected AbstractXmlHandler(Writer dest, int indentSize) throws VeraPDFException {
        this.indentSize = indentSize;
        try {
            this.writer = outputFactory.createXMLStreamWriter(dest);
        }
        catch (XMLStreamException excep) {
            throw AbstractXmlHandler.wrapStreamException(excep, "initialising");
        }
    }

    protected int indent() {
        return this.indent += this.indentSize;
    }

    protected int outdent() {
        if (this.indent >= this.indentSize) {
            return this.indent -= this.indentSize;
        }
        this.indent = 0;
        return 0;
    }

    protected static void startDoc(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument(encoding, xmlVersion);
    }

    protected static void endDoc(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndDocument();
    }

    protected void indentElement(String eleName) throws XMLStreamException {
        AbstractXmlHandler.newLine(this.writer, this.indent());
        this.writer.writeStartElement(eleName);
    }

    protected void addAttribute(String name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name, value);
    }

    protected void outdentElement() throws XMLStreamException {
        this.writer.writeEndElement();
        AbstractXmlHandler.newLine(this.writer, this.outdent());
    }

    protected static void newLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(newline);
    }

    protected static void newLine(XMLStreamWriter writer, int indent) throws XMLStreamException {
        AbstractXmlHandler.newLine(writer);
        writer.writeCharacters(new String(new char[indent]).replace('\u0000', ' '));
    }

    protected static VeraPDFException wrapStreamException(XMLStreamException excep) {
        return AbstractXmlHandler.wrapStreamException(excep, "writing to");
    }

    protected static VeraPDFException wrapStreamException(XMLStreamException excep, String verbPart) {
        return new VeraPDFException(String.format(strmExcpMessTmpl, verbPart), excep);
    }

    protected static final VeraPDFException wrapMarshallException(JAXBException excep, String typePart) {
        return new VeraPDFException(String.format(unmarshalErrMessage, typePart), excep);
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (XMLStreamException excep) {
            logger.log(Level.INFO, String.format(strmExcpMessTmpl, "closing"), excep);
        }
    }
}

