/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.processor.AbstractBatchHandler;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.ItemDetails;
import org.verapdf.report.FeaturesReport;

class SingleLineResultHandler
extends AbstractBatchHandler {
    private static final String ioExcepMess = "IOException caught when writing to output stream";
    private static final String parseExcepMessTmpl = "%s does not appear to be a valid PDF file and could not be parsed.";
    private static final String pdfEncryptMessTmpl = "%s appears to be an encrypted PDF file and could not be processed.";
    private OutputStream outputStream;
    private boolean isVerbose;
    private ItemDetails item;

    private SingleLineResultHandler(OutputStream outputStream) {
        this(outputStream, true);
    }

    private SingleLineResultHandler(OutputStream outputStream, boolean isVerbose) {
        this.outputStream = outputStream;
        this.isVerbose = isVerbose;
    }

    @Override
    public void handleBatchStart(ProcessorConfig config) {
    }

    @Override
    void resultStart(ProcessorResult result) {
        this.item = result.getProcessedItem();
    }

    @Override
    void parsingSuccess(TaskResult taskResult) {
    }

    @Override
    void parsingFailure(TaskResult taskResult) throws VeraPDFException {
        try {
            this.outputStream.write(String.format(parseExcepMessTmpl, this.item.getName()).getBytes());
        }
        catch (IOException excep) {
            throw new VeraPDFException(ioExcepMess, excep);
        }
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) throws VeraPDFException {
        try {
            this.outputStream.write(String.format(pdfEncryptMessTmpl, this.item.getName()).getBytes());
        }
        catch (IOException excep) {
            throw new VeraPDFException(ioExcepMess, excep);
        }
    }

    @Override
    void validationSuccess(TaskResult taskResult, ValidationResult validationResult) throws VeraPDFException {
        String reportSummary = (validationResult.isCompliant() ? "PASS " : "FAIL ") + this.item.getName() + "\n";
        try {
            this.outputStream.write(reportSummary.getBytes());
            if (this.isVerbose) {
                this.processFiledRules(validationResult);
            }
        }
        catch (IOException excep) {
            throw new VeraPDFException(ioExcepMess, excep);
        }
    }

    @Override
    void validationFailure(TaskResult taskResult) throws VeraPDFException {
        String reportSummary = "ERROR " + this.item.getName() + " " + taskResult.getType().fullName() + "\n";
        try {
            this.outputStream.write(reportSummary.getBytes());
        }
        catch (IOException excep) {
            throw new VeraPDFException(ioExcepMess, excep);
        }
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featuresReport) {
    }

    @Override
    void featureFailure(TaskResult taskResult) {
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) {
    }

    @Override
    void fixerFailure(TaskResult taskResult) {
    }

    @Override
    void resultEnd(ProcessorResult result) {
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) {
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != System.out) {
            this.outputStream.close();
        }
    }

    private void processFiledRules(ValidationResult validationResult) throws IOException {
        HashSet<RuleId> ruleIds = new HashSet<RuleId>();
        for (TestAssertion assertion : validationResult.getTestAssertions()) {
            if (assertion.getStatus() != TestAssertion.Status.FAILED) continue;
            ruleIds.add(assertion.getRuleId());
        }
        for (RuleId id : ruleIds) {
            String reportRuleSummary = id.getClause() + "-" + id.getTestNumber() + "\n";
            this.outputStream.write(reportRuleSummary.getBytes());
        }
    }

    static BatchProcessingHandler newInstance(OutputStream outputStream) {
        return new SingleLineResultHandler(outputStream);
    }

    static BatchProcessingHandler newInstance(OutputStream outputStream, boolean verbose) {
        return new SingleLineResultHandler(outputStream, verbose);
    }
}

