/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import javax.xml.bind.JAXBException;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.VeraAppConfigImpl;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureFactory;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;

final class ConfigManagerImpl
implements ConfigManager {
    private static final String nullArgMessage = "Arg tasks can not be null";
    private static final String defaultConfExt = ".xml";
    private static final String defaultValidName = "validator.xml";
    private static final String defaultFixerName = "fixer.xml";
    private static final String defaultFeaturesName = "features.xml";
    private static final String defaultPluginsName = "plugins.xml";
    private static final String defaultAppName = "app.xml";
    private final File root;
    private final File validatorFile;
    private final File fixerFile;
    private final File featuresFile;
    private final File pluginsFile;
    private final File appFile;

    private ConfigManagerImpl(File root) {
        this.root = root;
        this.validatorFile = this.getConfigFile(defaultValidName);
        this.fixerFile = this.getConfigFile(defaultFixerName);
        this.featuresFile = this.getConfigFile(defaultFeaturesName);
        this.pluginsFile = this.getConfigFile(defaultPluginsName);
        this.appFile = this.getConfigFile(defaultAppName);
        this.initialise();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidatorConfig getValidatorConfig() {
        try (FileInputStream fis = new FileInputStream(this.validatorFile);){
            ValidatorConfig validatorConfig = ValidatorFactory.createConfig(fis);
            return validatorConfig;
        }
        catch (IOException | JAXBException excep) {
            excep.printStackTrace();
            return ValidatorFactory.defaultConfig();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FeatureExtractorConfig getFeaturesConfig() {
        try (FileInputStream fis = new FileInputStream(this.featuresFile);){
            FeatureExtractorConfig featureExtractorConfig = FeatureFactory.configFromXml(fis);
            return featureExtractorConfig;
        }
        catch (IOException | JAXBException excep) {
            excep.printStackTrace();
            return FeatureFactory.defaultConfig();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PluginsCollectionConfig getPluginsCollectionConfig() {
        try (FileInputStream fis = new FileInputStream(this.pluginsFile);){
            PluginsCollectionConfig pluginsCollectionConfig = PluginsCollectionConfig.create(fis);
            return pluginsCollectionConfig;
        }
        catch (IOException | JAXBException excep) {
            excep.printStackTrace();
            return PluginsCollectionConfig.defaultConfig();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MetadataFixerConfig getFixerConfig() {
        try (FileInputStream fis = new FileInputStream(this.fixerFile);){
            MetadataFixerConfig metadataFixerConfig = FixerFactory.configFromXml(fis);
            return metadataFixerConfig;
        }
        catch (IOException | JAXBException excep) {
            excep.printStackTrace();
            return FixerFactory.defaultConfig();
        }
    }

    @Override
    public ProcessorConfig createProcessorConfig() {
        VeraAppConfig applicationConfig = this.getApplicationConfig();
        return this.createProcessorConfig(applicationConfig.getProcessType().getTasks(), applicationConfig.getFixesFolder());
    }

    @Override
    public ProcessorConfig createProcessorConfig(EnumSet<TaskType> tasks) {
        if (tasks == null) {
            throw new NullPointerException(nullArgMessage);
        }
        return ProcessorFactory.fromValues(this.getValidatorConfig(), this.getFeaturesConfig(), this.getPluginsCollectionConfig(), this.getFixerConfig(), tasks);
    }

    @Override
    public ProcessorConfig createProcessorConfig(EnumSet<TaskType> tasks, String mdFolder) {
        if (tasks == null) {
            throw new NullPointerException(nullArgMessage);
        }
        return ProcessorFactory.fromValues(this.getValidatorConfig(), this.getFeaturesConfig(), this.getPluginsCollectionConfig(), this.getFixerConfig(), tasks, mdFolder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VeraAppConfig getApplicationConfig() {
        try (FileInputStream fis = new FileInputStream(this.appFile);){
            VeraAppConfigImpl veraAppConfigImpl = VeraAppConfigImpl.fromXml(fis);
            return veraAppConfigImpl;
        }
        catch (IOException | JAXBException excep) {
            excep.printStackTrace();
            return VeraAppConfigImpl.defaultInstance();
        }
    }

    @Override
    public File getConfigDir() {
        return this.root;
    }

    @Override
    public void updateValidatorConfig(ValidatorConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.validatorFile, false);){
            ValidatorFactory.configToXml(config, fos);
        }
    }

    @Override
    public void updateFeaturesConfig(FeatureExtractorConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.featuresFile, false);){
            FeatureFactory.configToXml(config, fos);
        }
    }

    @Override
    public void updateFixerConfig(MetadataFixerConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.fixerFile, false);){
            FixerFactory.configToXml(config, fos);
        }
    }

    @Override
    public void updateAppConfig(VeraAppConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.appFile, false);){
            VeraAppConfigImpl.toXml(config, fos, Boolean.TRUE);
        }
    }

    static ConfigManagerImpl create(File root) {
        return new ConfigManagerImpl(root);
    }

    private void initialise() {
        block56: {
            try {
                Throwable throwable;
                FileOutputStream fos;
                if (!this.validatorFile.exists() && this.validatorFile.createNewFile() || this.validatorFile.length() == 0L) {
                    fos = new FileOutputStream(this.validatorFile, false);
                    throwable = null;
                    try {
                        ValidatorFactory.configToXml(ValidatorFactory.defaultConfig(), fos);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (fos != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)fos).close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                ((OutputStream)fos).close();
                            }
                        }
                    }
                }
                if (!this.featuresFile.exists() && this.featuresFile.createNewFile() || this.featuresFile.length() == 0L) {
                    fos = new FileOutputStream(this.featuresFile, false);
                    throwable = null;
                    try {
                        FeatureFactory.configToXml(FeatureFactory.defaultConfig(), fos);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (fos != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)fos).close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                ((OutputStream)fos).close();
                            }
                        }
                    }
                }
                if (!this.fixerFile.exists() && this.fixerFile.createNewFile() || this.fixerFile.length() == 0L) {
                    fos = new FileOutputStream(this.fixerFile, false);
                    throwable = null;
                    try {
                        FixerFactory.configToXml(FixerFactory.defaultConfig(), fos);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (fos != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)fos).close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                ((OutputStream)fos).close();
                            }
                        }
                    }
                }
                if ((this.appFile.exists() || !this.appFile.createNewFile()) && this.appFile.length() != 0L) break block56;
                fos = new FileOutputStream(this.appFile, false);
                throwable = null;
                try {
                    Applications.toXml(Applications.defaultConfig(), fos, Boolean.TRUE);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)fos).close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            ((OutputStream)fos).close();
                        }
                    }
                }
            }
            catch (IOException | JAXBException excep) {
                excep.printStackTrace();
                throw new IllegalStateException("Couldn't setup config", excep);
            }
        }
    }

    private final File getConfigFile(String name) {
        File config = new File(this.root, name);
        try {
            if (config.isDirectory() || !config.exists() && !config.createNewFile()) {
                throw new IllegalArgumentException(config.getAbsolutePath() + " must be a creatable or readable file");
            }
        }
        catch (IOException excep) {
            throw new IllegalArgumentException("IOException when creating: " + config.getAbsolutePath(), excep);
        }
        return config;
    }
}

