/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBOutputIntentsFeaturesObject
implements IFeaturesObject {
    private PDOutputIntent outInt;
    private String iccProfileID;

    public PBOutputIntentsFeaturesObject(PDOutputIntent outInt, String iccProfileID) {
        this.outInt = outInt;
        this.iccProfileID = iccProfileID;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.OUTPUTINTENT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.outInt != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("outputIntent");
            this.addSubtype(collection, root);
            PBCreateNodeHelper.addNotEmptyNode("outputCondition", this.outInt.getOutputCondition(), root);
            PBCreateNodeHelper.addNotEmptyNode("outputConditionIdentifier", this.outInt.getOutputConditionIdentifier(), root);
            PBCreateNodeHelper.addNotEmptyNode("registryName", this.outInt.getRegistryName(), root);
            PBCreateNodeHelper.addNotEmptyNode("info", this.outInt.getInfo(), root);
            if (this.iccProfileID != null) {
                FeatureTreeNode destOutInt = root.addChild("destOutputIntent");
                destOutInt.setAttribute("id", this.iccProfileID);
            }
            collection.addNewFeatureTree(FeatureObjectType.OUTPUTINTENT, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private void addSubtype(FeatureExtractionResult collection, FeatureTreeNode root) throws FeatureParsingException {
        COSBase base = this.outInt.getCOSObject();
        if (base instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)base;
            COSBase baseType = dict.getDictionaryObject(COSName.S);
            while (baseType instanceof COSObject) {
                baseType = ((COSObject)baseType).getObject();
            }
            if (baseType != null) {
                FeatureTreeNode type = root.addChild("subtype");
                if (baseType instanceof COSName) {
                    type.setValue(((COSName)baseType).getName());
                } else {
                    ErrorsHelper.addErrorIntoCollection(collection, type, "Subtype is not of Name type");
                }
            }
        }
    }
}

