/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.truetype.TrueTypeFontProgram;

public class PDTrueTypeFont
extends PDSimpleFont {
    private static final Logger LOGGER = Logger.getLogger(PDTrueTypeFont.class.getCanonicalName());

    public PDTrueTypeFont(COSDictionary dictionary) {
        super(dictionary);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FontProgram getFontProgram() {
        COSStream trueTypeFontFile;
        ASAtom subtype;
        if (this.isFontParsed) {
            return this.fontProgram;
        }
        this.isFontParsed = true;
        if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE2)) {
            COSStream trueTypeFontFile2 = this.fontDescriptor.getFontFile2();
            try (ASInputStream fontData2 = trueTypeFontFile2.getData(COSStream.FilterFlags.DECODE);){
                FontProgram fontProgram2 = this.fontProgram = new TrueTypeFontProgram(fontData2, this.isSymbolic(), this.getEncoding());
                return fontProgram2;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't read TrueType font program.", e);
            }
        } else if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE3) && (subtype = (trueTypeFontFile = this.fontDescriptor.getFontFile3()).getNameKey(ASAtom.SUBTYPE)) == ASAtom.OPEN_TYPE) {
            try (ASInputStream fontData = trueTypeFontFile.getData(COSStream.FilterFlags.DECODE);){
                FontProgram fontProgram = this.fontProgram = new OpenTypeFontProgram(fontData, false, this.isSymbolic(), this.getEncoding(), null, this.isSubset());
                return fontProgram;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't read TrueType font program.", e);
            }
        }
        this.fontProgram = null;
        return null;
    }
}

