/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.cli.CliConstants;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.core.VeraPDFException;
import org.verapdf.policy.PolicyChecker;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.reports.ItemDetails;

final class VeraPdfCliProcessor {
    private static final Logger logger = Logger.getLogger(VeraPdfCliProcessor.class.getCanonicalName());
    private final ConfigManager configManager;
    private final ProcessorConfig processorConfig;
    private final VeraAppConfig appConfig;
    private final boolean isPolicy;
    private final File tempMrrFile;
    private final File policyFile;
    private boolean isStdOut = true;
    private boolean appendData = true;
    private String baseDirectory = "";

    private VeraPdfCliProcessor(VeraCliArgParser args, ConfigManager configManager) throws VeraPDFException {
        File file;
        this.configManager = configManager;
        this.isPolicy = args.isPolicy();
        try {
            this.tempMrrFile = this.isPolicy ? File.createTempFile("mrr", "veraPDF") : null;
        }
        catch (IOException excep) {
            throw new VeraPDFException("Failed to create temporary MRR file", excep);
        }
        this.policyFile = args.getPolicyFile();
        this.appConfig = args.appConfig(configManager.getApplicationConfig());
        this.processorConfig = args.processorConfig(this.appConfig.getProcessType(), this.configManager.getFeaturesConfig(), this.configManager.getPluginsCollectionConfig());
        if (this.configManager.getApplicationConfig().isOverwriteReport() && (file = new File(this.configManager.getApplicationConfig().getReportFile())).exists()) {
            try {
                file.delete();
            }
            catch (SecurityException ex) {
                String message = String.format("Cannot delete existing report file : %s.", file.getPath());
                logger.log(Level.WARNING, message, ex);
            }
        }
    }

    VeraAppConfig getConfig() {
        return this.appConfig;
    }

    ProcessorConfig getProcessorConfig() {
        return this.processorConfig;
    }

    void processPaths(List<String> pdfPaths) throws VeraPDFException {
        if (pdfPaths.isEmpty()) {
            this.processStdIn();
        } else {
            this.processFilePaths(pdfPaths);
        }
        if (this.isPolicy) {
            this.applyPolicy();
        }
    }

    static VeraPdfCliProcessor createProcessorFromArgs(VeraCliArgParser args, ConfigManager config) throws VeraPDFException {
        return new VeraPdfCliProcessor(args, config);
    }

    private void processStdIn() {
        for (String messageLine : CliConstants.MESS_PROC_STDIN) {
            System.out.println(messageLine);
        }
        ItemDetails item = ItemDetails.fromValues("STDIN");
        this.processStream(item, System.in);
    }

    private void processFilePaths(List<String> paths) {
        ArrayList<File> toFilter = new ArrayList<File>();
        for (String path : paths) {
            toFilter.add(new File(path));
        }
        List<File> toProcess = ApplicationUtils.filterPdfFiles(toFilter);
        if (toProcess.isEmpty()) {
            return;
        }
        try (BatchProcessor processor = ProcessorFactory.fileBatchProcessor(this.processorConfig);
             OutputStream reportStream = this.getReportStream();){
            processor.process(toProcess, ProcessorFactory.getHandler(this.appConfig.getFormat(), this.appConfig.isVerbose(), reportStream, this.appConfig.getMaxFailsDisplayed(), this.processorConfig.getValidatorConfig().isRecordPasses()));
        }
        catch (VeraPDFException excep) {
            String message = "VeraPDFException raised while processing batch";
            System.err.println(message);
            logger.log(Level.SEVERE, message, excep);
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing MRR temp file.", excep);
        }
    }

    private void processStream(ItemDetails item, InputStream toProcess) {
        try (ItemProcessor processor = ProcessorFactory.createProcessor(this.processorConfig);){
            ProcessorResult result = processor.process(item, toProcess);
            OutputStream outputReportStream = this.getReportStream();
            try {
                if (result.isPdf() && !result.isEncryptedPdf()) {
                    ProcessorFactory.resultToXml(result, outputReportStream, true);
                } else {
                    String message = String.format(result.isPdf() ? "%s is an encrypted PDF document." : "%s is not a valid PDF.", item.getName());
                    outputReportStream.write(message.getBytes());
                }
            }
            catch (IOException | JAXBException excep) {
                logger.log(Level.SEVERE, "JAXBEception raised when marshalling report.", excep);
            }
            if (!this.isStdOut) {
                try {
                    outputReportStream.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Cannot close the report file.", ex);
                }
            }
        }
        catch (IOException excep) {
            logger.log(Level.FINER, "IOExeption raised when closing ItemProcessor", excep);
        }
    }

    private OutputStream getReportStream() {
        if (this.isPolicy) {
            if (this.tempMrrFile == null) {
                throw new IllegalStateException("Policy enabled BUT no temp destination");
            }
            try {
                this.isStdOut = false;
                return new FileOutputStream(this.tempMrrFile);
            }
            catch (FileNotFoundException excep) {
                throw new IllegalStateException("Policy enabled BUT no temp destination", excep);
            }
        }
        return System.out;
    }

    private void applyPolicy() throws VeraPDFException {
        File tempPolicyResult = null;
        try {
            tempPolicyResult = File.createTempFile("policyResult", "veraPDF");
        }
        catch (IOException excep) {
            throw new VeraPDFException("Could not create temporary policy result file.", excep);
        }
        try (FileInputStream mrrIs = new FileInputStream(this.tempMrrFile);
             FileOutputStream policyResultOs = new FileOutputStream(tempPolicyResult);){
            PolicyChecker.applyPolicy(this.policyFile, mrrIs, policyResultOs);
            PolicyChecker.insertPolicyReport(tempPolicyResult, this.tempMrrFile, System.out);
        }
        catch (FileNotFoundException excep) {
            throw new VeraPDFException("Could not find temporary policy result file.", excep);
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing temporary policy file.", excep);
        }
    }

    private String constructReportPath(String itemName) {
        String reportPath = "";
        if (!this.configManager.getApplicationConfig().getReportFolder().isEmpty()) {
            Path fileAbsolutePath = Paths.get(itemName, new String[0]);
            String pdfFileName = fileAbsolutePath.getFileName().toString();
            String pdfFileDirectory = fileAbsolutePath.getParent().toString();
            String extension = "." + this.configManager.getApplicationConfig().getFormat().toString();
            String outputFileName = pdfFileName.replace(".pdf", extension);
            String reportFolder = this.configManager.getApplicationConfig().getReportFolder();
            if (pdfFileDirectory.length() > this.baseDirectory.length()) {
                StringBuilder reportFolderBuilder = new StringBuilder();
                reportFolderBuilder.append(reportFolder);
                String subDirectory = pdfFileDirectory.substring(this.baseDirectory.length());
                reportFolderBuilder.append(subDirectory);
                reportFolder = reportFolderBuilder.toString();
                File dir = new File(reportFolder);
                if (!dir.exists()) {
                    try {
                        dir.mkdirs();
                    }
                    catch (SecurityException ex) {
                        logger.log(Level.SEVERE, "Cannot create subdirectories the: " + ex.toString() + "\n");
                        reportFolder = this.configManager.getApplicationConfig().getReportFolder();
                    }
                }
            }
            File reportFile = new File(reportFolder, outputFileName);
            reportPath = reportFile.getAbsolutePath();
            this.appendData = false;
        } else if (!this.configManager.getApplicationConfig().getReportFile().isEmpty()) {
            File reportFile = new File(this.configManager.getApplicationConfig().getReportFile());
            reportPath = reportFile.getAbsolutePath();
            this.appendData = true;
        }
        return reportPath;
    }
}

