/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEDictionaryBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;
import org.verapdf.features.objects.ColorSpaceFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBColorSpaceFeaturesObjectAdapter
implements ColorSpaceFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBColorSpaceFeaturesObjectAdapter.class);
    private PDColorSpace colorSpace;
    private String id;
    private String iccProfileChild;
    private String colorSpaceChild;
    private Long hival;
    private String hexEncodedLookup;
    private List<String> errors;

    public PBColorSpaceFeaturesObjectAdapter(PDColorSpace colorSpace, String id, String iccProfileChild, String colorSpaceChild) {
        this.colorSpace = colorSpace;
        this.id = id;
        this.iccProfileChild = iccProfileChild;
        this.colorSpaceChild = colorSpaceChild;
        if (colorSpace instanceof PDIndexed) {
            this.initIndexed();
        }
    }

    private void initIndexed() {
        PDIndexed index = (PDIndexed)this.colorSpace;
        this.errors = new ArrayList<String>();
        if (index.getCOSObject() instanceof COSArray) {
            if (((COSArray)index.getCOSObject()).size() >= 3 && ((COSArray)index.getCOSObject()).getObject(2) instanceof COSNumber) {
                this.hival = ((COSNumber)((COSArray)index.getCOSObject()).getObject(2)).intValue();
            } else {
                this.errors.add("Indexed color space has no element hival or hival is not a number");
            }
            if (((COSArray)index.getCOSObject()).size() >= 4) {
                byte[] lookupData = null;
                COSBase lookupTable = ((COSArray)index.getCOSObject()).getObject(3);
                if (lookupTable instanceof COSString) {
                    lookupData = ((COSString)lookupTable).getBytes();
                } else if (lookupTable instanceof COSStream) {
                    try {
                        lookupData = new PDStream((COSStream)lookupTable).getByteArray();
                    }
                    catch (IOException e) {
                        LOGGER.info(e);
                        this.errors.add(e.getMessage());
                    }
                } else {
                    this.errors.add("Indexed color space has element lookup but it is not a String or a Stream");
                }
                if (lookupData != null) {
                    this.hexEncodedLookup = DatatypeConverter.printHexBinary((byte[])lookupData);
                }
            } else {
                this.errors.add("Indexed color space has no element lookup");
            }
        } else {
            this.errors.add("Indexed color space is not an array");
        }
    }

    private static double[] parseTristimulus(PDTristimulus tris) {
        if (tris != null) {
            double[] res = new double[]{tris.getX(), tris.getY(), tris.getZ()};
            return res;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getICCProfileChild() {
        return this.iccProfileChild;
    }

    @Override
    public String getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    @Override
    public String getFamily() {
        if (this.colorSpace != null) {
            return this.colorSpace.getName();
        }
        return null;
    }

    @Override
    public double[] getWhitePoint() {
        if (this.colorSpace instanceof PDCIEDictionaryBasedColorSpace) {
            PDCIEDictionaryBasedColorSpace cie = (PDCIEDictionaryBasedColorSpace)this.colorSpace;
            return PBColorSpaceFeaturesObjectAdapter.parseTristimulus(cie.getWhitepoint());
        }
        return null;
    }

    @Override
    public double[] getBlackPoint() {
        if (this.colorSpace instanceof PDCIEDictionaryBasedColorSpace) {
            PDCIEDictionaryBasedColorSpace cie = (PDCIEDictionaryBasedColorSpace)this.colorSpace;
            return PBColorSpaceFeaturesObjectAdapter.parseTristimulus(cie.getBlackPoint());
        }
        return null;
    }

    @Override
    public Double getCalGrayGamma() {
        if (this.colorSpace instanceof PDCalGray) {
            PDCalGray calGray = (PDCalGray)this.colorSpace;
            return calGray.getGamma();
        }
        return null;
    }

    @Override
    public double[] getCalRGBGamma() {
        if (this.colorSpace instanceof PDCalRGB) {
            PDCalRGB calRGB = (PDCalRGB)this.colorSpace;
            PDGamma pdGamma = calRGB.getGamma();
            double[] res = new double[]{pdGamma.getR(), pdGamma.getG(), pdGamma.getB()};
            return res;
        }
        return null;
    }

    @Override
    public double[] getMatrix() {
        if (this.colorSpace instanceof PDCalRGB) {
            PDCalRGB calRGB = (PDCalRGB)this.colorSpace;
            return PBAdapterHelper.castFloatArrayToDouble(calRGB.getMatrix());
        }
        return null;
    }

    @Override
    public double[] getLabRange() {
        if (this.colorSpace instanceof PDLab) {
            PDLab lab = (PDLab)this.colorSpace;
            double[] res = new double[]{lab.getARange().getMin(), lab.getARange().getMax(), lab.getBRange().getMin(), lab.getBRange().getMax()};
            return res;
        }
        return null;
    }

    @Override
    public int getNumberOfComponents() {
        if (this.colorSpace instanceof PDICCBased) {
            PDICCBased icc = (PDICCBased)this.colorSpace;
            return icc.getNumberOfComponents();
        }
        return 0;
    }

    @Override
    public Long getHival() {
        return this.hival;
    }

    @Override
    public String getHexEncodedLookup() {
        return this.hexEncodedLookup;
    }

    @Override
    public String getColorantName() {
        if (this.colorSpace instanceof PDSeparation) {
            PDSeparation sep = (PDSeparation)this.colorSpace;
            return sep.getColorantName();
        }
        return null;
    }

    @Override
    public List<String> getColorantNames() {
        if (this.colorSpace instanceof PDDeviceN) {
            PDDeviceN devN = (PDDeviceN)this.colorSpace;
            List<String> devNColorantNames = devN.getColorantNames();
            return devNColorantNames == null ? Collections.emptyList() : Collections.unmodifiableList(devNColorantNames);
        }
        return null;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.colorSpace != null;
    }

    @Override
    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }
}

