/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDPage;
import org.verapdf.features.objects.PageFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBPageFeaturesObjectAdapter
implements PageFeaturesObjectAdapter {
    private PDPage page;
    private String label;
    private String thumb;
    private Set<String> annotsId;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private int index;
    private Double scaling;
    private List<String> errors;

    public PBPageFeaturesObjectAdapter(PDPage page, String label, String thumb, Set<String> annotsId, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild, int index) {
        COSBase base;
        this.page = page;
        this.label = label;
        this.thumb = thumb;
        this.annotsId = annotsId;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        this.index = index;
        if (page != null && (base = page.getCOSObject().getDictionaryObject(COSName.getPDFName("PZ"))) != null) {
            while (base instanceof COSObject) {
                base = ((COSObject)base).getObject();
            }
            if (base instanceof COSNumber) {
                COSNumber number = (COSNumber)base;
                this.scaling = number.doubleValue();
            } else {
                this.errors = new ArrayList<String>();
                this.errors.add("Scaling is not a number");
            }
        }
    }

    @Override
    public String getThumb() {
        return this.thumb;
    }

    @Override
    public Set<String> getAnnotsId() {
        return this.annotsId;
    }

    @Override
    public Set<String> getExtGStateChild() {
        return this.extGStateChild;
    }

    @Override
    public Set<String> getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    @Override
    public Set<String> getPatternChild() {
        return this.patternChild;
    }

    @Override
    public Set<String> getShadingChild() {
        return this.shadingChild;
    }

    @Override
    public Set<String> getXObjectChild() {
        return this.xobjectChild;
    }

    @Override
    public Set<String> getFontChild() {
        return this.fontChild;
    }

    @Override
    public Set<String> getPropertiesChild() {
        return this.propertiesChild;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public double[] getMediaBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getMediaBox());
        }
        return null;
    }

    @Override
    public double[] getCropBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getCropBox());
        }
        return null;
    }

    @Override
    public double[] getTrimBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getTrimBox());
        }
        return null;
    }

    @Override
    public double[] getBleedBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getBleedBox());
        }
        return null;
    }

    @Override
    public double[] getArtBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getArtBox());
        }
        return null;
    }

    @Override
    public Long getRotation() {
        if (this.page != null) {
            return this.page.getRotation();
        }
        return null;
    }

    @Override
    public Double getScaling() {
        return this.scaling;
    }

    @Override
    public InputStream getMetadataStream() {
        if (this.page != null) {
            return PBAdapterHelper.getMetadataStream(this.page.getMetadata());
        }
        return null;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.page != null;
    }

    @Override
    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }
}

